/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.util.deparser;

import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.expression.Expression;
import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.expression.ExpressionVisitor;
import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.statement.select.GroupByElement;
import java.util.Iterator;

public class GroupByDeParser {
    protected StringBuilder buffer;
    private ExpressionVisitor expressionVisitor;

    GroupByDeParser() {
    }

    public GroupByDeParser(ExpressionVisitor expressionVisitor, StringBuilder buffer) {
        this.expressionVisitor = expressionVisitor;
        this.buffer = buffer;
    }

    public void deParse(GroupByElement groupBy) {
        this.buffer.append("GROUP BY ");
        Iterator<Expression> iter = groupBy.getGroupByExpressions().iterator();
        while (iter.hasNext()) {
            iter.next().accept(this.expressionVisitor);
            if (!iter.hasNext()) continue;
            this.buffer.append(", ");
        }
        if (groupBy.getGroupingSets().size() > 0) {
            this.buffer.append("GROUPING SETS (");
            boolean first = true;
            for (Object o2 : groupBy.getGroupingSets()) {
                if (first) {
                    first = false;
                } else {
                    this.buffer.append(", ");
                }
                if (o2 instanceof Expression) {
                    this.buffer.append(o2.toString());
                    continue;
                }
                if (!(o2 instanceof ExpressionList)) continue;
                ExpressionList list = (ExpressionList)o2;
                this.buffer.append(list.getExpressions() == null ? "()" : list.toString());
            }
            this.buffer.append(")");
        }
    }

    void setExpressionVisitor(ExpressionVisitor expressionVisitor) {
        this.expressionVisitor = expressionVisitor;
    }

    void setBuffer(StringBuilder buffer) {
        this.buffer = buffer;
    }
}

