/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.com.google.common.collect;

import com.ververica.cdc.connectors.shaded.com.google.common.annotations.GwtCompatible;
import com.ververica.cdc.connectors.shaded.com.google.common.annotations.VisibleForTesting;
import com.ververica.cdc.connectors.shaded.com.google.common.collect.ImmutableBiMap;
import com.ververica.cdc.connectors.shaded.com.google.common.collect.ImmutableList;
import com.ververica.cdc.connectors.shaded.com.google.common.collect.ImmutableMapEntry;
import com.ververica.cdc.connectors.shaded.com.google.common.collect.ImmutableMapEntrySet;
import com.ververica.cdc.connectors.shaded.com.google.common.collect.ImmutableMapKeySet;
import com.ververica.cdc.connectors.shaded.com.google.common.collect.ImmutableSet;
import com.ververica.cdc.connectors.shaded.com.google.common.collect.Maps;
import com.ververica.cdc.connectors.shaded.com.google.common.collect.RegularImmutableMap;
import com.ververica.cdc.connectors.shaded.com.google.errorprone.annotations.concurrent.LazyInit;
import com.ververica.cdc.connectors.shaded.com.google.j2objc.annotations.RetainedWith;
import java.util.HashMap;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtCompatible(emulated=true)
final class JdkBackedImmutableBiMap<K, V>
extends ImmutableBiMap<K, V> {
    private final transient ImmutableList<Map.Entry<K, V>> entries;
    private final Map<K, V> forwardDelegate;
    private final Map<V, K> backwardDelegate;
    @LazyInit
    @RetainedWith
    private transient JdkBackedImmutableBiMap<V, K> inverse;

    @VisibleForTesting
    static <K, V> ImmutableBiMap<K, V> create(int n2, Map.Entry<K, V>[] entryArray) {
        HashMap forwardDelegate = Maps.newHashMapWithExpectedSize(n2);
        HashMap backwardDelegate = Maps.newHashMapWithExpectedSize(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            ImmutableMapEntry<K, V> e2 = RegularImmutableMap.makeImmutable(entryArray[i2]);
            entryArray[i2] = e2;
            Object oldValue = forwardDelegate.putIfAbsent(e2.getKey(), e2.getValue());
            if (oldValue != null) {
                String string = String.valueOf(e2.getKey());
                String string2 = String.valueOf(oldValue);
                throw JdkBackedImmutableBiMap.conflictException("key", new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("=").append(string2).toString(), entryArray[i2]);
            }
            Object oldKey = backwardDelegate.putIfAbsent(e2.getValue(), e2.getKey());
            if (oldKey == null) continue;
            String string = String.valueOf(oldKey);
            String string3 = String.valueOf(e2.getValue());
            throw JdkBackedImmutableBiMap.conflictException("value", new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string3).length()).append(string).append("=").append(string3).toString(), entryArray[i2]);
        }
        ImmutableList<Map.Entry<K, V>> entryList = ImmutableList.asImmutableList(entryArray, n2);
        return new JdkBackedImmutableBiMap<K, V>(entryList, forwardDelegate, backwardDelegate);
    }

    private JdkBackedImmutableBiMap(ImmutableList<Map.Entry<K, V>> entries, Map<K, V> forwardDelegate, Map<V, K> backwardDelegate) {
        this.entries = entries;
        this.forwardDelegate = forwardDelegate;
        this.backwardDelegate = backwardDelegate;
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public ImmutableBiMap<V, K> inverse() {
        JdkBackedImmutableBiMap<K, V> result = this.inverse;
        if (result == null) {
            this.inverse = result = new JdkBackedImmutableBiMap<K, V>(new InverseEntries(), this.backwardDelegate, this.forwardDelegate);
            result.inverse = this;
        }
        return result;
    }

    @Override
    public V get(@Nullable Object key) {
        return this.forwardDelegate.get(key);
    }

    @Override
    ImmutableSet<Map.Entry<K, V>> createEntrySet() {
        return new ImmutableMapEntrySet.RegularEntrySet<K, V>(this, this.entries);
    }

    @Override
    ImmutableSet<K> createKeySet() {
        return new ImmutableMapKeySet(this);
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    private final class InverseEntries
    extends ImmutableList<Map.Entry<V, K>> {
        private InverseEntries() {
        }

        @Override
        public Map.Entry<V, K> get(int index) {
            Map.Entry entry = (Map.Entry)JdkBackedImmutableBiMap.this.entries.get(index);
            return Maps.immutableEntry(entry.getValue(), entry.getKey());
        }

        @Override
        boolean isPartialView() {
            return false;
        }

        @Override
        public int size() {
            return JdkBackedImmutableBiMap.this.entries.size();
        }
    }
}

