/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.module.jaxb.ser;

import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.core.JsonGenerator;
import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.databind.JavaType;
import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.databind.JsonNode;
import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.databind.SerializerProvider;
import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.databind.node.ObjectNode;
import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import javax.activation.DataHandler;

public class DataHandlerJsonSerializer
extends StdSerializer<DataHandler> {
    private static final long serialVersionUID = 1L;

    public DataHandlerJsonSerializer() {
        super(DataHandler.class);
    }

    @Override
    public void serialize(DataHandler value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        InputStream in = value.getInputStream();
        int len = in.read(buffer);
        while (len > 0) {
            out.write(buffer, 0, len);
            len = in.read(buffer);
        }
        in.close();
        jgen.writeBinary(out.toByteArray());
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        JsonArrayFormatVisitor v2;
        if (visitor != null && (v2 = visitor.expectArrayFormat(typeHint)) != null) {
            v2.itemsFormat(JsonFormatTypes.STRING);
        }
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        ObjectNode o2 = this.createSchemaNode("array", true);
        ObjectNode itemSchema = this.createSchemaNode("string");
        o2.set("items", itemSchema);
        return o2;
    }
}

