/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.datatype.jdk8;

import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.core.JsonParser;
import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.core.JsonToken;
import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.datatype.jdk8.BaseScalarOptionalDeserializer;
import java.io.IOException;
import java.util.OptionalInt;

public class OptionalIntDeserializer
extends BaseScalarOptionalDeserializer<OptionalInt> {
    private static final long serialVersionUID = 1L;
    static final OptionalIntDeserializer INSTANCE = new OptionalIntDeserializer();

    public OptionalIntDeserializer() {
        super(OptionalInt.class, OptionalInt.empty());
    }

    @Override
    public OptionalInt deserialize(JsonParser p2, DeserializationContext ctxt) throws IOException {
        if (p2.hasToken(JsonToken.VALUE_NUMBER_INT)) {
            return OptionalInt.of(p2.getIntValue());
        }
        switch (p2.getCurrentTokenId()) {
            case 6: {
                String text = p2.getText().trim();
                if (text.length() == 0) {
                    this._coerceEmptyString(ctxt, false);
                    return (OptionalInt)this._empty;
                }
                if (this._hasTextualNull(text)) {
                    this._coerceTextualNull(ctxt, false);
                    return (OptionalInt)this._empty;
                }
                return OptionalInt.of(this._parseIntPrimitive(ctxt, text));
            }
            case 8: {
                if (!ctxt.isEnabled(DeserializationFeature.ACCEPT_FLOAT_AS_INT)) {
                    this._failDoubleToIntCoercion(p2, ctxt, "int");
                }
                return OptionalInt.of(p2.getValueAsInt());
            }
            case 11: {
                return (OptionalInt)this._empty;
            }
            case 3: {
                if (!ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) break;
                p2.nextToken();
                OptionalInt parsed = this.deserialize(p2, ctxt);
                this._verifyEndArrayForSingle(p2, ctxt);
                return parsed;
            }
        }
        return (OptionalInt)ctxt.handleUnexpectedToken(this._valueClass, p2);
    }
}

