/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.oracle.table;

import com.ververica.cdc.connectors.base.options.StartupOptions;
import com.ververica.cdc.connectors.oracle.OracleSource;
import com.ververica.cdc.connectors.oracle.source.OracleSourceBuilder;
import com.ververica.cdc.connectors.oracle.table.OracleDeserializationConverterFactory;
import com.ververica.cdc.connectors.oracle.table.OracleReadableMetaData;
import com.ververica.cdc.debezium.DebeziumSourceFunction;
import com.ververica.cdc.debezium.table.MetadataConverter;
import com.ververica.cdc.debezium.table.RowDataDebeziumDeserializeSchema;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.ScanTableSource;
import org.apache.flink.table.connector.source.SourceFunctionProvider;
import org.apache.flink.table.connector.source.SourceProvider;
import org.apache.flink.table.connector.source.abilities.SupportsReadingMetadata;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Preconditions;

public class OracleTableSource
implements ScanTableSource,
SupportsReadingMetadata {
    private final ResolvedSchema physicalSchema;
    @Nullable
    private final String url;
    private final int port;
    private final String hostname;
    private final String database;
    private final String username;
    private final String password;
    private final String tableName;
    private final String schemaName;
    private final Properties dbzProperties;
    private final StartupOptions startupOptions;
    private final boolean enableParallelRead;
    private final int splitSize;
    private final int splitMetaGroupSize;
    private final int fetchSize;
    private final Duration connectTimeout;
    private final int connectionPoolSize;
    private final int connectMaxRetries;
    private final double distributionFactorUpper;
    private final double distributionFactorLower;
    private final String chunkKeyColumn;
    protected DataType producedDataType;
    protected List<String> metadataKeys;

    public OracleTableSource(ResolvedSchema physicalSchema, @Nullable String url, int port, String hostname, String database, String tableName, String schemaName, String username, String password, Properties dbzProperties, StartupOptions startupOptions, boolean enableParallelRead, int splitSize, int splitMetaGroupSize, int fetchSize, Duration connectTimeout, int connectMaxRetries, int connectionPoolSize, double distributionFactorUpper, double distributionFactorLower, @Nullable String chunkKeyColumn) {
        this.physicalSchema = physicalSchema;
        this.url = url;
        this.port = port;
        this.hostname = (String)Preconditions.checkNotNull((Object)hostname);
        this.database = (String)Preconditions.checkNotNull((Object)database);
        this.tableName = (String)Preconditions.checkNotNull((Object)tableName);
        this.schemaName = (String)Preconditions.checkNotNull((Object)schemaName);
        this.username = (String)Preconditions.checkNotNull((Object)username);
        this.password = (String)Preconditions.checkNotNull((Object)password);
        this.dbzProperties = dbzProperties;
        this.startupOptions = startupOptions;
        this.producedDataType = physicalSchema.toPhysicalRowDataType();
        this.metadataKeys = Collections.emptyList();
        this.enableParallelRead = enableParallelRead;
        this.splitSize = splitSize;
        this.splitMetaGroupSize = splitMetaGroupSize;
        this.fetchSize = fetchSize;
        this.connectTimeout = connectTimeout;
        this.connectMaxRetries = connectMaxRetries;
        this.connectionPoolSize = connectionPoolSize;
        this.distributionFactorUpper = distributionFactorUpper;
        this.distributionFactorLower = distributionFactorLower;
        this.chunkKeyColumn = chunkKeyColumn;
    }

    public ChangelogMode getChangelogMode() {
        return ChangelogMode.newBuilder().addContainedKind(RowKind.INSERT).addContainedKind(RowKind.UPDATE_BEFORE).addContainedKind(RowKind.UPDATE_AFTER).addContainedKind(RowKind.DELETE).build();
    }

    public ScanTableSource.ScanRuntimeProvider getScanRuntimeProvider(ScanTableSource.ScanContext scanContext) {
        RowType physicalDataType = (RowType)this.physicalSchema.toPhysicalRowDataType().getLogicalType();
        MetadataConverter[] metadataConverters = this.getMetadataConverters();
        TypeInformation typeInfo = scanContext.createTypeInformation(this.producedDataType);
        RowDataDebeziumDeserializeSchema deserializer = RowDataDebeziumDeserializeSchema.newBuilder().setPhysicalRowType(physicalDataType).setMetadataConverters(metadataConverters).setResultTypeInfo((TypeInformation<RowData>)typeInfo).setUserDefinedConverterFactory(OracleDeserializationConverterFactory.instance()).build();
        if (this.enableParallelRead) {
            OracleSourceBuilder.OracleIncrementalSource<RowData> oracleChangeEventSource = OracleSourceBuilder.OracleIncrementalSource.builder().hostname(this.hostname).url(this.url).port(this.port).databaseList(this.database).schemaList(this.schemaName).tableList(this.schemaName + "." + this.tableName).username(this.username).password(this.password).startupOptions(this.startupOptions).deserializer(deserializer).debeziumProperties(this.dbzProperties).splitSize(this.splitSize).splitMetaGroupSize(this.splitMetaGroupSize).fetchSize(this.fetchSize).connectTimeout(this.connectTimeout).connectionPoolSize(this.connectionPoolSize).connectMaxRetries(this.connectMaxRetries).distributionFactorUpper(this.distributionFactorUpper).distributionFactorLower(this.distributionFactorLower).build();
            return SourceProvider.of(oracleChangeEventSource);
        }
        OracleSource.Builder<RowData> builder = OracleSource.builder().hostname(this.hostname).url(this.url).port(this.port).database(this.database).tableList(this.schemaName + "." + this.tableName).schemaList(this.schemaName).username(this.username).password(this.password).debeziumProperties(this.dbzProperties).startupOptions(this.startupOptions).deserializer(deserializer);
        DebeziumSourceFunction<RowData> sourceFunction = builder.build();
        return SourceFunctionProvider.of(sourceFunction, (boolean)false);
    }

    private MetadataConverter[] getMetadataConverters() {
        if (this.metadataKeys.isEmpty()) {
            return new MetadataConverter[0];
        }
        return (MetadataConverter[])this.metadataKeys.stream().map(key -> Stream.of(OracleReadableMetaData.values()).filter(m2 -> m2.getKey().equals(key)).findFirst().orElseThrow(IllegalStateException::new)).map(OracleReadableMetaData::getConverter).toArray(MetadataConverter[]::new);
    }

    public DynamicTableSource copy() {
        OracleTableSource source = new OracleTableSource(this.physicalSchema, this.url, this.port, this.hostname, this.database, this.tableName, this.schemaName, this.username, this.password, this.dbzProperties, this.startupOptions, this.enableParallelRead, this.splitSize, this.splitMetaGroupSize, this.fetchSize, this.connectTimeout, this.connectMaxRetries, this.connectionPoolSize, this.distributionFactorUpper, this.distributionFactorLower, this.chunkKeyColumn);
        source.metadataKeys = this.metadataKeys;
        source.producedDataType = this.producedDataType;
        return source;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        OracleTableSource that = (OracleTableSource)o2;
        return Objects.equals(this.url, that.url) && Objects.equals(this.port, that.port) && Objects.equals(this.physicalSchema, that.physicalSchema) && Objects.equals(this.hostname, that.hostname) && Objects.equals(this.database, that.database) && Objects.equals(this.username, that.username) && Objects.equals(this.password, that.password) && Objects.equals(this.tableName, that.tableName) && Objects.equals(this.schemaName, that.schemaName) && Objects.equals(this.dbzProperties, that.dbzProperties) && Objects.equals(this.startupOptions, that.startupOptions) && Objects.equals(this.producedDataType, that.producedDataType) && Objects.equals(this.metadataKeys, that.metadataKeys) && Objects.equals(this.enableParallelRead, that.enableParallelRead) && Objects.equals(this.splitSize, that.splitSize) && Objects.equals(this.splitMetaGroupSize, that.splitMetaGroupSize) && Objects.equals(this.fetchSize, that.fetchSize) && Objects.equals(this.connectTimeout, that.connectTimeout) && Objects.equals(this.connectMaxRetries, that.connectMaxRetries) && Objects.equals(this.connectionPoolSize, that.connectionPoolSize) && Objects.equals(this.distributionFactorUpper, that.distributionFactorUpper) && Objects.equals(this.distributionFactorLower, that.distributionFactorLower) && Objects.equals(this.chunkKeyColumn, that.chunkKeyColumn);
    }

    public int hashCode() {
        return Objects.hash(this.physicalSchema, this.url, this.port, this.hostname, this.database, this.username, this.password, this.tableName, this.schemaName, this.dbzProperties, this.startupOptions, this.producedDataType, this.metadataKeys, this.enableParallelRead, this.splitSize, this.splitMetaGroupSize, this.fetchSize, this.connectTimeout, this.connectMaxRetries, this.connectionPoolSize, this.distributionFactorUpper, this.distributionFactorLower, this.chunkKeyColumn);
    }

    public String asSummaryString() {
        return "Oracle-CDC";
    }

    public Map<String, DataType> listReadableMetadata() {
        return Stream.of(OracleReadableMetaData.values()).collect(Collectors.toMap(OracleReadableMetaData::getKey, OracleReadableMetaData::getDataType));
    }

    public void applyReadableMetadata(List<String> metadataKeys, DataType producedDataType) {
        this.metadataKeys = metadataKeys;
        this.producedDataType = producedDataType;
    }
}

