/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.oracle.source.reader.fetch;

import com.ververica.cdc.connectors.base.relational.JdbcSourceEventDispatcher;
import com.ververica.cdc.connectors.base.source.meta.split.SourceSplitBase;
import com.ververica.cdc.connectors.base.source.meta.split.StreamSplit;
import com.ververica.cdc.connectors.base.source.meta.wartermark.WatermarkKind;
import com.ververica.cdc.connectors.base.source.reader.external.FetchTask;
import com.ververica.cdc.connectors.oracle.source.meta.offset.RedoLogOffset;
import com.ververica.cdc.connectors.oracle.source.reader.fetch.OracleScanFetchTask;
import com.ververica.cdc.connectors.oracle.source.reader.fetch.OracleSourceFetchTaskContext;
import io.debezium.DebeziumException;
import io.debezium.config.Configuration;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleDatabaseSchema;
import io.debezium.connector.oracle.OracleOffsetContext;
import io.debezium.connector.oracle.OracleStreamingChangeEventSourceMetrics;
import io.debezium.connector.oracle.logminer.LogMinerStreamingChangeEventSource;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.source.spi.ChangeEventSource;
import io.debezium.util.Clock;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleStreamFetchTask
implements FetchTask<SourceSplitBase> {
    private final StreamSplit split;
    private volatile boolean taskRunning = false;
    private RedoLogSplitReadTask redoLogSplitReadTask;

    public OracleStreamFetchTask(StreamSplit split) {
        this.split = split;
    }

    @Override
    public void execute(FetchTask.Context context) throws Exception {
        OracleSourceFetchTaskContext sourceFetchContext = (OracleSourceFetchTaskContext)context;
        this.taskRunning = true;
        this.redoLogSplitReadTask = new RedoLogSplitReadTask(sourceFetchContext.getDbzConnectorConfig(), sourceFetchContext.getConnection(), sourceFetchContext.getDispatcher(), sourceFetchContext.getErrorHandler(), sourceFetchContext.getDatabaseSchema(), sourceFetchContext.getSourceConfig().getOriginDbzConnectorConfig(), sourceFetchContext.getStreamingChangeEventSourceMetrics(), this.split);
        RedoLogSplitChangeEventSourceContext changeEventSourceContext = new RedoLogSplitChangeEventSourceContext();
        this.redoLogSplitReadTask.execute((ChangeEventSource.ChangeEventSourceContext)changeEventSourceContext, sourceFetchContext.getOffsetContext());
    }

    @Override
    public boolean isRunning() {
        return this.taskRunning;
    }

    @Override
    public StreamSplit getSplit() {
        return this.split;
    }

    private class RedoLogSplitChangeEventSourceContext
    implements ChangeEventSource.ChangeEventSourceContext {
        private RedoLogSplitChangeEventSourceContext() {
        }

        @Override
        public boolean isRunning() {
            return OracleStreamFetchTask.this.taskRunning;
        }
    }

    public static class RedoLogSplitReadTask
    extends LogMinerStreamingChangeEventSource {
        private static final Logger LOG = LoggerFactory.getLogger(RedoLogSplitReadTask.class);
        private final StreamSplit redoLogSplit;
        private final JdbcSourceEventDispatcher dispatcher;
        private final ErrorHandler errorHandler;
        private ChangeEventSource.ChangeEventSourceContext context;

        public RedoLogSplitReadTask(OracleConnectorConfig connectorConfig, OracleConnection connection, JdbcSourceEventDispatcher dispatcher, ErrorHandler errorHandler, OracleDatabaseSchema schema, Configuration jdbcConfig, OracleStreamingChangeEventSourceMetrics metrics, StreamSplit redoLogSplit) {
            super(connectorConfig, connection, dispatcher, errorHandler, Clock.SYSTEM, schema, jdbcConfig, metrics);
            this.redoLogSplit = redoLogSplit;
            this.dispatcher = dispatcher;
            this.errorHandler = errorHandler;
        }

        @Override
        public void execute(ChangeEventSource.ChangeEventSourceContext context, OracleOffsetContext offsetContext) {
            this.context = context;
            super.execute(context, offsetContext);
        }

        @Override
        public void afterHandleScn(OracleOffsetContext offsetContext) {
            RedoLogOffset currentRedoLogOffset;
            super.afterHandleScn(offsetContext);
            if (this.isBoundedRead() && (currentRedoLogOffset = RedoLogSplitReadTask.getCurrentRedoLogOffset(offsetContext.getOffset())).isAtOrAfter(this.redoLogSplit.getEndingOffset())) {
                try {
                    this.dispatcher.dispatchWatermarkEvent(offsetContext.getPartition(), this.redoLogSplit, currentRedoLogOffset, WatermarkKind.END);
                }
                catch (InterruptedException e2) {
                    LOG.error("Send signal event error.", (Throwable)e2);
                    this.errorHandler.setProducerThrowable(new DebeziumException("Error processing binlog signal event", e2));
                }
                ((OracleScanFetchTask.SnapshotBinlogSplitChangeEventSourceContext)this.context).finished();
            }
        }

        private boolean isBoundedRead() {
            return !RedoLogOffset.NO_STOPPING_OFFSET.equals(this.redoLogSplit.getEndingOffset());
        }

        public static RedoLogOffset getCurrentRedoLogOffset(Map<String, ?> offset) {
            HashMap<String, String> offsetStrMap = new HashMap<String, String>();
            for (Map.Entry<String, ?> entry : offset.entrySet()) {
                offsetStrMap.put(entry.getKey(), entry.getValue() == null ? null : entry.getValue().toString());
            }
            return new RedoLogOffset(offsetStrMap);
        }
    }
}

