/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.oracle.source.config;

import com.ververica.cdc.connectors.base.config.JdbcSourceConfigFactory;
import com.ververica.cdc.connectors.base.source.EmbeddedFlinkDatabaseHistory;
import com.ververica.cdc.connectors.oracle.source.config.OracleSourceConfig;
import io.debezium.config.Configuration;
import io.debezium.connector.oracle.OracleConnector;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.flink.util.Preconditions;

public class OracleSourceConfigFactory
extends JdbcSourceConfigFactory {
    private static final long serialVersionUID = 1L;
    private static final String DATABASE_SERVER_NAME = "oracle_logminer";
    private static final String DRIVER_ClASS_NAME = "oracle.jdbc.OracleDriver";
    @Nullable
    private String url;
    private List<String> schemaList;

    public JdbcSourceConfigFactory url(@Nullable String url) {
        this.url = url;
        return this;
    }

    public JdbcSourceConfigFactory schemaList(String ... schemaList) {
        this.schemaList = Arrays.asList(schemaList);
        return this;
    }

    @Override
    public OracleSourceConfig create(int subtaskId) {
        Properties props = new Properties();
        props.setProperty("connector.class", OracleConnector.class.getCanonicalName());
        props.setProperty("database.server.name", DATABASE_SERVER_NAME);
        props.setProperty("database.user", (String)Preconditions.checkNotNull((Object)this.username));
        props.setProperty("database.password", (String)Preconditions.checkNotNull((Object)this.password));
        props.setProperty("database.history.skip.unparseable.ddl", String.valueOf(true));
        props.setProperty("database.dbname", (String)Preconditions.checkNotNull(this.databaseList.get(0)));
        props.setProperty("database.history", EmbeddedFlinkDatabaseHistory.class.getCanonicalName());
        props.setProperty("database.history.instance.name", UUID.randomUUID() + "_" + subtaskId);
        props.setProperty("database.history.skip.unparseable.ddl", String.valueOf(true));
        props.setProperty("database.history.refer.ddl", String.valueOf(true));
        props.setProperty("connect.timeout.ms", String.valueOf(this.connectTimeout.toMillis()));
        props.setProperty("tombstones.on.delete", String.valueOf(false));
        if (this.url != null) {
            props.setProperty("database.url", this.url);
        } else {
            Preconditions.checkNotNull((Object)this.hostname, (String)"hostname is required when url is not configured");
            props.setProperty("database.hostname", this.hostname);
            Preconditions.checkNotNull((Object)this.port, (String)"port is required when url is not configured");
            props.setProperty("database.port", String.valueOf(this.port));
        }
        if (this.schemaList != null) {
            props.setProperty("schema.whitelist", String.join((CharSequence)",", this.schemaList));
        }
        if (this.tableList != null) {
            props.setProperty("table.include.list", String.join((CharSequence)",", this.tableList));
        }
        if (this.dbzProperties != null) {
            props.putAll((Map<?, ?>)this.dbzProperties);
        }
        Configuration dbzConfiguration = Configuration.from(props);
        return new OracleSourceConfig(this.startupOptions, this.databaseList, this.tableList, this.splitSize, this.splitMetaGroupSize, this.distributionFactorUpper, this.distributionFactorLower, this.includeSchemaChanges, props, dbzConfiguration, DRIVER_ClASS_NAME, this.url, this.hostname, this.port, this.username, this.password, this.fetchSize, this.serverTimeZone, this.connectTimeout, this.connectMaxRetries, this.connectionPoolSize, this.chunkKeyColumn);
    }
}

