/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.oracle.source;

import com.ververica.cdc.connectors.base.options.StartupOptions;
import com.ververica.cdc.connectors.base.source.jdbc.JdbcIncrementalSource;
import com.ververica.cdc.connectors.base.source.meta.offset.OffsetFactory;
import com.ververica.cdc.connectors.oracle.source.OracleDialect;
import com.ververica.cdc.connectors.oracle.source.config.OracleSourceConfigFactory;
import com.ververica.cdc.connectors.oracle.source.meta.offset.RedoLogOffsetFactory;
import com.ververica.cdc.debezium.DebeziumDeserializationSchema;
import java.time.Duration;
import java.util.Properties;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.util.Preconditions;

@Internal
public class OracleSourceBuilder<T> {
    private final OracleSourceConfigFactory configFactory = new OracleSourceConfigFactory();
    private RedoLogOffsetFactory offsetFactory;
    private OracleDialect dialect;
    private DebeziumDeserializationSchema<T> deserializer;

    public OracleSourceBuilder<T> hostname(String hostname) {
        this.configFactory.hostname(hostname);
        return this;
    }

    public OracleSourceBuilder<T> url(@Nullable String url) {
        this.configFactory.url(url);
        return this;
    }

    public OracleSourceBuilder<T> port(int port) {
        this.configFactory.port(port);
        return this;
    }

    public OracleSourceBuilder<T> databaseList(String ... databaseList) {
        this.configFactory.databaseList(databaseList);
        return this;
    }

    public OracleSourceBuilder<T> schemaList(String ... schemaList) {
        this.configFactory.schemaList(schemaList);
        return this;
    }

    public OracleSourceBuilder<T> tableList(String ... tableList) {
        this.configFactory.tableList(tableList);
        return this;
    }

    public OracleSourceBuilder<T> username(String username) {
        this.configFactory.username(username);
        return this;
    }

    public OracleSourceBuilder<T> password(String password) {
        this.configFactory.password(password);
        return this;
    }

    public OracleSourceBuilder<T> serverTimeZone(String timeZone) {
        this.configFactory.serverTimeZone(timeZone);
        return this;
    }

    public OracleSourceBuilder<T> splitSize(int splitSize) {
        this.configFactory.splitSize(splitSize);
        return this;
    }

    public OracleSourceBuilder<T> splitMetaGroupSize(int splitMetaGroupSize) {
        this.configFactory.splitMetaGroupSize(splitMetaGroupSize);
        return this;
    }

    public OracleSourceBuilder<T> distributionFactorUpper(double distributionFactorUpper) {
        this.configFactory.distributionFactorUpper(distributionFactorUpper);
        return this;
    }

    public OracleSourceBuilder<T> distributionFactorLower(double distributionFactorLower) {
        this.configFactory.distributionFactorLower(distributionFactorLower);
        return this;
    }

    public OracleSourceBuilder<T> fetchSize(int fetchSize) {
        this.configFactory.fetchSize(fetchSize);
        return this;
    }

    public OracleSourceBuilder<T> connectTimeout(Duration connectTimeout) {
        this.configFactory.connectTimeout(connectTimeout);
        return this;
    }

    public OracleSourceBuilder<T> connectMaxRetries(int connectMaxRetries) {
        this.configFactory.connectMaxRetries(connectMaxRetries);
        return this;
    }

    public OracleSourceBuilder<T> connectionPoolSize(int connectionPoolSize) {
        this.configFactory.connectionPoolSize(connectionPoolSize);
        return this;
    }

    public OracleSourceBuilder<T> includeSchemaChanges(boolean includeSchemaChanges) {
        this.configFactory.includeSchemaChanges(includeSchemaChanges);
        return this;
    }

    public OracleSourceBuilder<T> startupOptions(StartupOptions startupOptions) {
        this.configFactory.startupOptions(startupOptions);
        return this;
    }

    public OracleSourceBuilder<T> chunkKeyColumn(String chunkKeyColumn) {
        this.configFactory.chunkKeyColumn(chunkKeyColumn);
        return this;
    }

    public OracleSourceBuilder<T> debeziumProperties(Properties properties) {
        this.configFactory.debeziumProperties(properties);
        return this;
    }

    public OracleSourceBuilder<T> deserializer(DebeziumDeserializationSchema<T> deserializer) {
        this.deserializer = deserializer;
        return this;
    }

    public OracleIncrementalSource<T> build() {
        this.offsetFactory = new RedoLogOffsetFactory();
        this.dialect = new OracleDialect(this.configFactory);
        return new OracleIncrementalSource(this.configFactory, (DebeziumDeserializationSchema)Preconditions.checkNotNull(this.deserializer), this.offsetFactory, this.dialect);
    }

    public static class OracleIncrementalSource<T>
    extends JdbcIncrementalSource<T> {
        public OracleIncrementalSource(OracleSourceConfigFactory configFactory, DebeziumDeserializationSchema<T> deserializationSchema, RedoLogOffsetFactory offsetFactory, OracleDialect dataSourceDialect) {
            super(configFactory, deserializationSchema, (OffsetFactory)offsetFactory, dataSourceDialect);
        }

        public static <T> OracleSourceBuilder<T> builder() {
            return new OracleSourceBuilder();
        }
    }
}

