/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.base.source.reader.external;

import com.ververica.cdc.connectors.base.source.meta.offset.Offset;
import com.ververica.cdc.connectors.base.source.meta.split.FinishedSnapshotSplitInfo;
import com.ververica.cdc.connectors.base.source.meta.split.SourceRecords;
import com.ververica.cdc.connectors.base.source.meta.split.SourceSplitBase;
import com.ververica.cdc.connectors.base.source.meta.split.StreamSplit;
import com.ververica.cdc.connectors.base.source.reader.external.FetchTask;
import com.ververica.cdc.connectors.base.source.reader.external.Fetcher;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.source.SourceRecord;
import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.pipeline.DataChangeEvent;
import io.debezium.relational.TableId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.flink.shaded.guava30.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.flink.util.FlinkRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncrementalSourceStreamFetcher
implements Fetcher<SourceRecords, SourceSplitBase> {
    private static final Logger LOG = LoggerFactory.getLogger(IncrementalSourceStreamFetcher.class);
    private final FetchTask.Context taskContext;
    private final ExecutorService executorService;
    private final Set<TableId> pureStreamPhaseTables;
    private volatile ChangeEventQueue<DataChangeEvent> queue;
    private volatile Throwable readException;
    private FetchTask<SourceSplitBase> streamFetchTask;
    private StreamSplit currentStreamSplit;
    private Map<TableId, List<FinishedSnapshotSplitInfo>> finishedSplitsInfo;
    private Map<TableId, Offset> maxSplitHighWatermarkMap;
    private static final long READER_CLOSE_TIMEOUT_SECONDS = 30L;

    public IncrementalSourceStreamFetcher(FetchTask.Context taskContext, int subTaskId) {
        this.taskContext = taskContext;
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("debezium-reader-" + subTaskId).build();
        this.executorService = Executors.newSingleThreadExecutor(threadFactory);
        this.pureStreamPhaseTables = new HashSet<TableId>();
    }

    @Override
    public void submitTask(FetchTask<SourceSplitBase> fetchTask) {
        this.streamFetchTask = fetchTask;
        this.currentStreamSplit = fetchTask.getSplit().asStreamSplit();
        this.configureFilter();
        this.taskContext.configure(this.currentStreamSplit);
        this.queue = this.taskContext.getQueue();
        this.executorService.submit(() -> {
            try {
                this.streamFetchTask.execute(this.taskContext);
            }
            catch (Exception e2) {
                LOG.error(String.format("Execute stream read task for stream split %s fail", this.currentStreamSplit), (Throwable)e2);
                this.readException = e2;
            }
        });
    }

    @Override
    public boolean isFinished() {
        return this.currentStreamSplit == null || !this.streamFetchTask.isRunning();
    }

    @Override
    @Nullable
    public Iterator<SourceRecords> pollSplitRecords() throws InterruptedException {
        this.checkReadException();
        ArrayList<SourceRecord> sourceRecords = new ArrayList<SourceRecord>();
        if (this.streamFetchTask.isRunning()) {
            List<DataChangeEvent> batch = this.queue.poll();
            for (DataChangeEvent event : batch) {
                if (!this.shouldEmit(event.getRecord())) continue;
                sourceRecords.add(event.getRecord());
            }
        }
        ArrayList<SourceRecords> sourceRecordsSet = new ArrayList<SourceRecords>();
        sourceRecordsSet.add(new SourceRecords(sourceRecords));
        return sourceRecordsSet.iterator();
    }

    private void checkReadException() {
        if (this.readException != null) {
            throw new FlinkRuntimeException(String.format("Read split %s error due to %s.", this.currentStreamSplit, this.readException.getMessage()), this.readException);
        }
    }

    @Override
    public void close() {
        try {
            if (this.executorService != null) {
                this.executorService.shutdown();
                if (this.executorService.awaitTermination(30L, TimeUnit.SECONDS)) {
                    LOG.warn("Failed to close the stream fetcher in {} seconds.", (Object)30L);
                }
            }
        }
        catch (Exception e2) {
            LOG.error("Close stream fetcher error", (Throwable)e2);
        }
    }

    private boolean shouldEmit(SourceRecord sourceRecord) {
        if (this.taskContext.isDataChangeRecord(sourceRecord)) {
            Offset position;
            TableId tableId = this.taskContext.getTableId(sourceRecord);
            if (this.hasEnterPureStreamPhase(tableId, position = this.taskContext.getStreamOffset(sourceRecord))) {
                return true;
            }
            if (this.finishedSplitsInfo.containsKey(tableId)) {
                for (FinishedSnapshotSplitInfo splitInfo : this.finishedSplitsInfo.get(tableId)) {
                    if (!this.taskContext.isRecordBetween(sourceRecord, splitInfo.getSplitStart(), splitInfo.getSplitEnd()) || !position.isAfter(splitInfo.getHighWatermark())) continue;
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    private boolean hasEnterPureStreamPhase(TableId tableId, Offset position) {
        if (this.pureStreamPhaseTables.contains(tableId)) {
            return true;
        }
        if (this.maxSplitHighWatermarkMap.containsKey(tableId) && position.isAtOrAfter(this.maxSplitHighWatermarkMap.get(tableId))) {
            this.pureStreamPhaseTables.add(tableId);
            return true;
        }
        return !this.maxSplitHighWatermarkMap.containsKey(tableId) && this.taskContext.getTableFilter().isIncluded(tableId);
    }

    private void configureFilter() {
        List<FinishedSnapshotSplitInfo> finishedSplitInfos = this.currentStreamSplit.getFinishedSnapshotSplitInfos();
        HashMap<TableId, List<FinishedSnapshotSplitInfo>> splitsInfoMap = new HashMap<TableId, List<FinishedSnapshotSplitInfo>>();
        HashMap<TableId, Offset> tableIdOffsetPositionMap = new HashMap<TableId, Offset>();
        if (finishedSplitInfos.isEmpty()) {
            for (TableId tableId : this.currentStreamSplit.getTableSchemas().keySet()) {
                tableIdOffsetPositionMap.put(tableId, this.currentStreamSplit.getStartingOffset());
            }
        } else {
            for (FinishedSnapshotSplitInfo finishedSplitInfo : finishedSplitInfos) {
                TableId tableId = finishedSplitInfo.getTableId();
                List list = splitsInfoMap.getOrDefault(tableId, new ArrayList());
                list.add(finishedSplitInfo);
                splitsInfoMap.put(tableId, list);
                Offset highWatermark = finishedSplitInfo.getHighWatermark();
                Offset maxHighWatermark = (Offset)tableIdOffsetPositionMap.get(tableId);
                if (maxHighWatermark != null && !highWatermark.isAfter(maxHighWatermark)) continue;
                tableIdOffsetPositionMap.put(tableId, highWatermark);
            }
        }
        this.finishedSplitsInfo = splitsInfoMap;
        this.maxSplitHighWatermarkMap = tableIdOffsetPositionMap;
        this.pureStreamPhaseTables.clear();
    }
}

