/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.base.source.reader;

import com.ververica.cdc.connectors.base.config.SourceConfig;
import com.ververica.cdc.connectors.base.dialect.DataSourceDialect;
import com.ververica.cdc.connectors.base.source.meta.split.ChangeEventRecords;
import com.ververica.cdc.connectors.base.source.meta.split.SourceRecords;
import com.ververica.cdc.connectors.base.source.meta.split.SourceSplitBase;
import com.ververica.cdc.connectors.base.source.reader.external.FetchTask;
import com.ververica.cdc.connectors.base.source.reader.external.Fetcher;
import com.ververica.cdc.connectors.base.source.reader.external.IncrementalSourceScanFetcher;
import com.ververica.cdc.connectors.base.source.reader.external.IncrementalSourceStreamFetcher;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Queue;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.connector.base.source.reader.RecordsWithSplitIds;
import org.apache.flink.connector.base.source.reader.splitreader.SplitReader;
import org.apache.flink.connector.base.source.reader.splitreader.SplitsAddition;
import org.apache.flink.connector.base.source.reader.splitreader.SplitsChange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
public class IncrementalSourceSplitReader<C extends SourceConfig>
implements SplitReader<SourceRecords, SourceSplitBase> {
    private static final Logger LOG = LoggerFactory.getLogger(IncrementalSourceSplitReader.class);
    private final Queue<SourceSplitBase> splits;
    private final int subtaskId;
    @Nullable
    private Fetcher<SourceRecords, SourceSplitBase> currentFetcher;
    @Nullable
    private String currentSplitId;
    private final DataSourceDialect<C> dataSourceDialect;
    private final C sourceConfig;

    public IncrementalSourceSplitReader(int subtaskId, DataSourceDialect<C> dataSourceDialect, C sourceConfig) {
        this.subtaskId = subtaskId;
        this.splits = new ArrayDeque<SourceSplitBase>();
        this.dataSourceDialect = dataSourceDialect;
        this.sourceConfig = sourceConfig;
    }

    public RecordsWithSplitIds<SourceRecords> fetch() throws IOException {
        this.checkSplitOrStartNext();
        Iterator<SourceRecords> dataIt = null;
        try {
            dataIt = this.currentFetcher.pollSplitRecords();
        }
        catch (InterruptedException e2) {
            LOG.warn("fetch data failed.", (Throwable)e2);
            throw new IOException(e2);
        }
        return dataIt == null ? this.finishedSnapshotSplit() : ChangeEventRecords.forRecords(this.currentSplitId, dataIt);
    }

    public void handleSplitsChanges(SplitsChange<SourceSplitBase> splitsChanges) {
        if (!(splitsChanges instanceof SplitsAddition)) {
            throw new UnsupportedOperationException(String.format("The SplitChange type of %s is not supported.", splitsChanges.getClass()));
        }
        LOG.debug("Handling split change {}", splitsChanges);
        this.splits.addAll(splitsChanges.splits());
    }

    public void wakeUp() {
    }

    public void close() throws Exception {
        if (this.currentFetcher != null) {
            LOG.info("Close current fetcher {}", (Object)this.currentFetcher.getClass().getCanonicalName());
            this.currentFetcher.close();
            this.currentSplitId = null;
        }
    }

    protected void checkSplitOrStartNext() throws IOException {
        if (this.currentFetcher instanceof IncrementalSourceStreamFetcher) {
            return;
        }
        if (this.canAssignNextSplit()) {
            SourceSplitBase nextSplit = this.splits.poll();
            if (nextSplit == null) {
                throw new IOException("Cannot fetch from another split - no split remaining.");
            }
            this.currentSplitId = nextSplit.splitId();
            if (nextSplit.isSnapshotSplit()) {
                if (this.currentFetcher == null) {
                    FetchTask.Context taskContext = this.dataSourceDialect.createFetchTaskContext(nextSplit, this.sourceConfig);
                    this.currentFetcher = new IncrementalSourceScanFetcher(taskContext, this.subtaskId);
                }
            } else {
                if (this.currentFetcher != null) {
                    LOG.info("It's turn to read stream split, close current snapshot fetcher.");
                    this.currentFetcher.close();
                }
                FetchTask.Context taskContext = this.dataSourceDialect.createFetchTaskContext(nextSplit, this.sourceConfig);
                this.currentFetcher = new IncrementalSourceStreamFetcher(taskContext, this.subtaskId);
                LOG.info("Stream fetcher is created.");
            }
            this.currentFetcher.submitTask(this.dataSourceDialect.createFetchTask(nextSplit));
        }
    }

    @VisibleForTesting
    public boolean canAssignNextSplit() {
        return this.currentFetcher == null || this.currentFetcher.isFinished();
    }

    private ChangeEventRecords finishedSnapshotSplit() {
        ChangeEventRecords finishedRecords = ChangeEventRecords.forFinishedSplit(this.currentSplitId);
        this.currentSplitId = null;
        return finishedRecords;
    }
}

