/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.base.source.meta.split;

import com.ververica.cdc.connectors.base.source.meta.offset.Offset;
import com.ververica.cdc.connectors.base.source.meta.split.SchemalessSnapshotSplit;
import com.ververica.cdc.connectors.base.source.meta.split.SourceSplitBase;
import io.debezium.relational.TableId;
import io.debezium.relational.history.TableChanges;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.table.types.logical.RowType;

public class SnapshotSplit
extends SourceSplitBase {
    private final TableId tableId;
    private final RowType splitKeyType;
    private final Map<TableId, TableChanges.TableChange> tableSchemas;
    @Nullable
    private final Object[] splitStart;
    @Nullable
    private final Object[] splitEnd;
    @Nullable
    private final Offset highWatermark;
    @Nullable
    transient byte[] serializedFormCache;

    public SnapshotSplit(TableId tableId, String splitId, RowType splitKeyType, Object[] splitStart, Object[] splitEnd, Offset highWatermark, Map<TableId, TableChanges.TableChange> tableSchemas) {
        super(splitId);
        this.tableId = tableId;
        this.splitKeyType = splitKeyType;
        this.splitStart = splitStart;
        this.splitEnd = splitEnd;
        this.highWatermark = highWatermark;
        this.tableSchemas = tableSchemas;
    }

    public TableId getTableId() {
        return this.tableId;
    }

    @Nullable
    public Object[] getSplitStart() {
        return this.splitStart;
    }

    @Nullable
    public Object[] getSplitEnd() {
        return this.splitEnd;
    }

    @Nullable
    public Offset getHighWatermark() {
        return this.highWatermark;
    }

    public boolean isSnapshotReadFinished() {
        return this.highWatermark != null;
    }

    @Override
    public Map<TableId, TableChanges.TableChange> getTableSchemas() {
        return this.tableSchemas;
    }

    public final SchemalessSnapshotSplit toSchemalessSnapshotSplit() {
        return new SchemalessSnapshotSplit(this.tableId, this.splitId, this.splitKeyType, this.splitStart, this.splitEnd, this.highWatermark);
    }

    @Override
    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        if (!super.equals(o2)) {
            return false;
        }
        SnapshotSplit that = (SnapshotSplit)o2;
        return Objects.equals(this.tableId, that.tableId) && Objects.equals(this.splitKeyType, that.splitKeyType) && Arrays.equals(this.splitStart, that.splitStart) && Arrays.equals(this.splitEnd, that.splitEnd) && Objects.equals(this.highWatermark, that.highWatermark);
    }

    public RowType getSplitKeyType() {
        return this.splitKeyType;
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(super.hashCode(), this.tableId, this.splitKeyType, this.highWatermark);
        result = 31 * result + Arrays.hashCode(this.splitStart);
        result = 31 * result + Arrays.hashCode(this.splitEnd);
        result = 31 * result + Arrays.hashCode(this.serializedFormCache);
        return result;
    }

    public String toString() {
        String splitKeyTypeSummary = this.splitKeyType.getFields().stream().map(RowType.RowField::asSummaryString).collect(Collectors.joining(",", "[", "]"));
        return "SnapshotSplit{tableId=" + this.tableId + ", splitId='" + this.splitId + '\'' + ", splitKeyType=" + splitKeyTypeSummary + ", splitStart=" + Arrays.toString(this.splitStart) + ", splitEnd=" + Arrays.toString(this.splitEnd) + ", highWatermark=" + this.highWatermark + '}';
    }
}

