/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.postgres.table;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.ververica.cdc.debezium.table.DeserializationRuntimeConverter;
import com.ververica.cdc.debezium.table.DeserializationRuntimeConverterFactory;
import io.debezium.util.HexConverter;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.Optional;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;

public class PostgreSQLDeserializationConverterFactory {
    public static final String SRID = "srid";
    public static final String HEXEWKB = "hexewkb";

    public static DeserializationRuntimeConverterFactory instance() {
        return new DeserializationRuntimeConverterFactory(){
            private static final long serialVersionUID = 1L;

            public Optional<DeserializationRuntimeConverter> createUserDefinedConverter(LogicalType logicalType, ZoneId serverTimeZone) {
                switch (logicalType.getTypeRoot()) {
                    case VARCHAR: {
                        return PostgreSQLDeserializationConverterFactory.createStringConverter();
                    }
                }
                return Optional.empty();
            }
        };
    }

    private static Optional<DeserializationRuntimeConverter> createStringConverter() {
        ObjectMapper objectMapper = new ObjectMapper();
        final ObjectWriter objectWriter = objectMapper.writer();
        return Optional.of(new DeserializationRuntimeConverter(){
            private static final long serialVersionUID = 1L;

            public Object convert(Object dbzObj, Schema schema) throws Exception {
                if ("io.debezium.data.geometry.Geometry".equals(schema.name()) || "io.debezium.data.geometry.Geography".equals(schema.name())) {
                    try {
                        Struct geometryStruct = (Struct)dbzObj;
                        byte[] wkb = geometryStruct.getBytes("wkb");
                        Optional<Integer> srid = Optional.ofNullable(geometryStruct.getInt32(PostgreSQLDeserializationConverterFactory.SRID));
                        HashMap<String, Object> geometryInfo = new HashMap<String, Object>(2);
                        geometryInfo.put(PostgreSQLDeserializationConverterFactory.HEXEWKB, HexConverter.convertToHexString((byte[])wkb));
                        geometryInfo.put(PostgreSQLDeserializationConverterFactory.SRID, srid.orElse(0));
                        return StringData.fromString((String)objectWriter.writeValueAsString(geometryInfo));
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException(String.format("Failed to convert %s to geometry JSON.", dbzObj), e);
                    }
                }
                return StringData.fromString((String)dbzObj.toString());
            }
        });
    }
}

