/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.vertica.dataengine.ColumnDescription;
import com.vertica.util.ClientErrorException;
import com.vertica.util.TypeUtils;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Struct;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class VerticaStruct
implements Struct {
    private ColumnDescription m_columnDescription;
    private JsonObject m_jsonObject;

    public VerticaStruct(ColumnDescription columnDescription, JsonObject jsonObject) {
        this.m_columnDescription = columnDescription;
        this.m_jsonObject = jsonObject;
    }

    public String toString() {
        return this.m_jsonObject.toString();
    }

    @Override
    public Object[] getAttributes() throws SQLException {
        Set<Map.Entry<String, JsonElement>> set = this.m_jsonObject.entrySet();
        Iterator<Map.Entry<String, JsonElement>> iterator = set.iterator();
        ListIterator<ColumnDescription> listIterator = this.m_columnDescription.getChildColumnIterator();
        Object[] objectArray = new Object[set.size()];
        int n = 0;
        while (iterator.hasNext() && listIterator.hasNext()) {
            Map.Entry<String, JsonElement> entry = iterator.next();
            ColumnDescription columnDescription = listIterator.next();
            JsonElement jsonElement = entry.getValue();
            try {
                objectArray[n] = TypeUtils.parseJsonElement(columnDescription, jsonElement);
            }
            catch (ClientErrorException clientErrorException) {
                throw new SQLException(clientErrorException.getMessage(), clientErrorException);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new SQLException(unsupportedEncodingException.getMessage(), unsupportedEncodingException);
            }
            ++n;
        }
        if (iterator.hasNext() || listIterator.hasNext()) {
            throw new SQLException("Warning: Invalid Complex Type ROW data.  The metadata does not match the fields in the ROW.  Actual values are: " + this.m_jsonObject.toString());
        }
        return objectArray;
    }

    @Override
    public Object[] getAttributes(Map<String, Class<?>> map) throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public String getSQLTypeName() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }
}

