/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.dsi.dataengine.filters;

import com.vertica.dsi.dataengine.filters.IFilter;
import com.vertica.dsi.dataengine.utilities.DataWrapper;
import com.vertica.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.vertica.dsi.exceptions.IncorrectTypeException;

public class IdentifierFilter
implements IFilter {
    private MetadataSourceColumnTag m_columnTag;
    private String m_value = null;

    public IdentifierFilter(MetadataSourceColumnTag columnTag, String value, String quoteChar) {
        this.m_columnTag = columnTag;
        if (null != value) {
            int endIndex;
            boolean isQuoted = false;
            int startIndex = -1;
            if (null != quoteChar && 0 < quoteChar.length()) {
                startIndex = value.indexOf(quoteChar);
            }
            if (-1 != startIndex && -1 != (endIndex = value.indexOf(quoteChar, startIndex + 1))) {
                isQuoted = true;
                this.m_value = value.substring(startIndex, endIndex);
            }
            if (!isQuoted) {
                this.m_value = value.trim();
            }
        }
    }

    @Override
    public boolean filter(DataWrapper data) {
        if (null == this.m_value) {
            return true;
        }
        if (data.isNull()) {
            return false;
        }
        try {
            switch (data.getType()) {
                case -8: 
                case 1: {
                    return this.m_value.equalsIgnoreCase(data.getChar());
                }
                case -9: 
                case 12: {
                    return this.m_value.equalsIgnoreCase(data.getVarChar());
                }
                case -10: 
                case -1: {
                    return this.m_value.equalsIgnoreCase(data.getLongVarChar());
                }
                case 5: {
                    return this.m_value.equals(Integer.toString(data.getSmallInt()));
                }
            }
        }
        catch (IncorrectTypeException incorrectTypeException) {
            // empty catch block
        }
        assert (false);
        return false;
    }

    @Override
    public MetadataSourceColumnTag getColumnTag() {
        return this.m_columnTag;
    }
}

