/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.dataengine;

import com.vertica.deserializer.Deserializer;
import com.vertica.deserializer.impl.ArrayDeserializerImpl;
import com.vertica.deserializer.impl.BoolDeserializerImpl;
import com.vertica.deserializer.impl.DateDeserializerImpl;
import com.vertica.deserializer.impl.FloatDeserializerImpl;
import com.vertica.deserializer.impl.IntegerDeserializerImpl;
import com.vertica.deserializer.impl.IntervalDeserializerImpl;
import com.vertica.deserializer.impl.IntervalYMDeserializerImpl;
import com.vertica.deserializer.impl.MultiFormatDeserializerImpl;
import com.vertica.deserializer.impl.NumericDeserializerImpl;
import com.vertica.deserializer.impl.StringDeserializerImpl;
import com.vertica.deserializer.impl.StructDeserializerImpl;
import com.vertica.deserializer.impl.TimeDeserializerImpl;
import com.vertica.deserializer.impl.TimestampDeserializerImpl;
import com.vertica.deserializer.impl.TimestampTZDeserializerImpl;
import com.vertica.deserializer.impl.UUIDDeserializerImpl;
import com.vertica.deserializer.impl.VarBinaryDeserializerImpl;
import com.vertica.dsi.dataengine.interfaces.IColumn;
import com.vertica.dsi.dataengine.utilities.ColumnMetadata;
import com.vertica.dsi.dataengine.utilities.DataWrapper;
import com.vertica.dsi.dataengine.utilities.Nullable;
import com.vertica.dsi.dataengine.utilities.TypeMetadata;
import com.vertica.dsi.dataengine.utilities.Updatable;
import com.vertica.dsi.exceptions.NumericOverflowException;
import com.vertica.support.exceptions.DiagState;
import com.vertica.support.exceptions.ErrorException;
import com.vertica.util.ClientErrorException;
import com.vertica.util.TypeUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;

public class ColumnDescription
extends ColumnMetadata {
    private int m_baseTypeOid;
    private int m_typemod;
    private int m_formatCode;
    private short m_sqlType;
    private int m_parentColID;
    private long m_tableOID;
    private int m_AttributeNum;
    private Deserializer m_deserializer;

    public ColumnDescription(String string, String string2, String string3, String string4, int n, int n2, int n3, int n4, int n5, String string5, int n6, long l, int n7) throws NumericOverflowException, ClientErrorException {
        super(TypeUtils.createTypeMetadata(n, n4, string5));
        this.m_baseTypeOid = n;
        this.m_sqlType = this.getTypeMetadata().getType();
        this.m_typemod = n4;
        this.m_formatCode = n5;
        this.m_parentColID = n6;
        this.m_tableOID = l;
        this.m_AttributeNum = n7;
        this.m_deserializer = this.createDeserializerForOid(n);
        this.setTableName(string3);
        this.setName(string);
        this.setLabel(string);
        this.setSchemaName(string2);
        this.setCatalogName(string4);
        this.setNullable(n2 == 1 ? Nullable.NULLABLE : Nullable.NO_NULLS);
        this.setAutoUnique(n3 == 1);
        boolean bl = "".equals(string2) || "v_catalog".equals(string2) || "v_monitor".equals(string2) || "v_internal".equals(string2) || "".equals(string3) || this.isAutoUnique();
        this.setUpdatable(bl ? Updatable.READ_ONLY : Updatable.UNKNOWN);
        if (this.m_baseTypeOid == 116 || this.m_baseTypeOid == 115 || this.m_baseTypeOid == 8 || this.m_baseTypeOid == 4 || this.m_baseTypeOid == 9 || this.m_baseTypeOid == 117 || this.m_baseTypeOid == 17) {
            this.setColumnLength(TypeUtils.getColumnSize(n, n4));
        }
    }

    public void addChildColumn(ColumnDescription columnDescription) throws ClientErrorException {
        throw new ClientErrorException("Fundamental Types do not support child columns.");
    }

    public ListIterator<ColumnDescription> getChildColumnIterator() {
        return null;
    }

    public int getSQLType() {
        return this.m_sqlType;
    }

    public int getTypeOID() {
        return this.m_baseTypeOid;
    }

    public int getTypeMod() {
        return this.m_typemod;
    }

    public int getFormatCode() {
        return this.m_formatCode;
    }

    public int getParentColumnID() {
        return this.m_parentColID;
    }

    public long getTableOID() {
        return this.m_tableOID;
    }

    public int getAttributeNum() {
        return this.m_AttributeNum;
    }

    public String toDebugString() {
        String string;
        String string2 = this.getSchemaName();
        if ("".equals(string2)) {
            string2 = "<none>";
        }
        if ("".equals(string = this.getSchemaName())) {
            string = "<none>";
        }
        TypeMetadata typeMetadata = this.getTypeMetadata();
        return "OID: " + this.m_baseTypeOid + " typemod: " + this.m_typemod + " format code: " + this.m_formatCode + " SQL type: " + this.m_sqlType + " schema: " + string2 + " table: " + string + " name: " + this.getName() + " nullable: " + (Object)((Object)this.getNullable()) + " autounique: " + this.isAutoUnique() + " precision: " + typeMetadata.getPrecision() + " scale: " + typeMetadata.getScale() + " table OID: " + this.m_tableOID;
    }

    public ColumnDescription findEnclosedArrayType() throws ErrorException {
        ColumnDescription columnDescription = this;
        while (columnDescription.getColumnType() == 2003) {
            if ((columnDescription = columnDescription.getBaseArrayColumn()) != null) continue;
            throw new RuntimeException("Unexpected failure retrieving array base type. Array base type reported as null.");
        }
        return columnDescription;
    }

    public ColumnDescription getBaseArrayColumn() throws ErrorException {
        TypeMetadata typeMetadata = this.getTypeMetadata();
        if (typeMetadata == null) {
            throw new ErrorException(DiagState.DIAG_GENERAL_ERROR, "Invalid Type Definition.  There is no type metadata.", -1);
        }
        ArrayList<IColumn> arrayList = typeMetadata.getNestedColumnList();
        if (arrayList == null) {
            throw new ErrorException(DiagState.DIAG_GENERAL_ERROR, "Invalid Type Definition.  There is no nested column list.", -1);
        }
        if (arrayList.size() != 1) {
            throw new ErrorException(DiagState.DIAG_GENERAL_ERROR, 101, "Invalid Type Definition.  There should be exactly one nested column.");
        }
        IColumn iColumn = arrayList.get(0);
        if (iColumn == null) {
            throw new ClientErrorException("Unexpected Failure. Nested column was determined to be null.");
        }
        if (!(iColumn instanceof ColumnDescription)) {
            throw new ClientErrorException("Unexpected Failure. Nested column was not a ColumnDescription.");
        }
        return (ColumnDescription)iColumn;
    }

    public int getColumnType() throws ErrorException {
        TypeMetadata typeMetadata = this.getTypeMetadata();
        if (typeMetadata == null) {
            throw new ErrorException(DiagState.DIAG_GENERAL_ERROR, "Invalid Type Definition.  There is no type metadata.", -1);
        }
        return typeMetadata.getType();
    }

    public boolean deserialize(long l, long l2, DataWrapper dataWrapper, byte[] byArray, HashMap<String, Object> hashMap) {
        if (byArray == null) {
            dataWrapper.setNull(this.getSQLType());
            return false;
        }
        try {
            return this.m_deserializer.deserialize(l, l2, dataWrapper, byArray, hashMap);
        }
        catch (Exception exception) {
            throw new RuntimeException("An exception occurred while attempting to deserialize: " + exception.getClass().getCanonicalName());
        }
    }

    private Deserializer createDeserializerForOid(int n) {
        switch (n) {
            case 4: 
            case 8: 
            case 9: 
            case 115: {
                return new StringDeserializerImpl();
            }
            case 11: 
            case 15: {
                return new MultiFormatDeserializerImpl(this.getFormatCode(), new TimeDeserializerImpl(n));
            }
            case 5: {
                return new MultiFormatDeserializerImpl(this.getFormatCode(), new BoolDeserializerImpl());
            }
            case 7: {
                return new MultiFormatDeserializerImpl(this.getFormatCode(), new FloatDeserializerImpl());
            }
            case 16: {
                return new MultiFormatDeserializerImpl(this.getFormatCode(), new NumericDeserializerImpl(this.getTypeMod()));
            }
            case 6: {
                return new MultiFormatDeserializerImpl(this.getFormatCode(), new IntegerDeserializerImpl());
            }
            case 12: {
                return new MultiFormatDeserializerImpl(this.getFormatCode(), new TimestampDeserializerImpl(n));
            }
            case 10: {
                return new MultiFormatDeserializerImpl(this.getFormatCode(), new DateDeserializerImpl());
            }
            case 13: {
                return new MultiFormatDeserializerImpl(this.getFormatCode(), new TimestampTZDeserializerImpl(n));
            }
            case 17: 
            case 116: 
            case 117: {
                return new VarBinaryDeserializerImpl();
            }
            case 20: {
                return new MultiFormatDeserializerImpl(this.getFormatCode(), new UUIDDeserializerImpl());
            }
            case 114: {
                return new IntervalYMDeserializerImpl(this.getSQLType(), this.getFormatCode());
            }
            case 14: {
                return new IntervalDeserializerImpl(this.getSQLType(), this.getTypeMod(), this.getFormatCode());
            }
            case 301: 
            case 1505: 
            case 1506: 
            case 1507: 
            case 1508: 
            case 1509: 
            case 1510: 
            case 1511: 
            case 1512: 
            case 1513: 
            case 1514: 
            case 1515: 
            case 1516: 
            case 1517: 
            case 1518: 
            case 1519: 
            case 1520: 
            case 1521: 
            case 1522: 
            case 2705: 
            case 2706: 
            case 2707: 
            case 2708: 
            case 2709: 
            case 2710: 
            case 2711: 
            case 2712: 
            case 2713: 
            case 2714: 
            case 2715: 
            case 2716: 
            case 2717: 
            case 2718: 
            case 2719: 
            case 2720: 
            case 2721: 
            case 2722: {
                return new ArrayDeserializerImpl(this);
            }
            case 300: 
            case 302: {
                return new StructDeserializerImpl(this);
            }
        }
        return new StringDeserializerImpl();
    }
}

