/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.dsi.dataengine.utilities;

import com.vertica.dsi.dataengine.interfaces.IArray;
import com.vertica.dsi.dataengine.utilities.DSIMonthSpan;
import com.vertica.dsi.dataengine.utilities.DSITimeSpan;
import com.vertica.dsi.dataengine.utilities.TimeTz;
import com.vertica.dsi.dataengine.utilities.TimestampTz;
import com.vertica.dsi.dataengine.utilities.TypeUtilities;
import com.vertica.dsi.exceptions.IncorrectTypeException;
import com.vertica.support.conv.ConverterConstants;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.sql.Date;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;

public final class DataWrapper {
    private static Map<Integer, List<Class<?>>> TYPE_CLASSES_MAP = new HashMap();
    private static final Charset UTF8_CHARSET;
    private int m_type = 0;
    private Object m_value = null;
    private boolean m_bigIntWasSetAsLongThroughSetData;

    private static void addTypeClassesMap() {
        ArrayList<Class<Object>> classList = new ArrayList<Class<Object>>();
        classList.add(BigInteger.class);
        classList.add(Long.class);
        TYPE_CLASSES_MAP.put(-5, classList);
        classList = new ArrayList();
        classList.add(Boolean.class);
        TYPE_CLASSES_MAP.put(-7, classList);
        classList = new ArrayList();
        classList.add(Date.class);
        classList.add(java.util.Date.class);
        classList.add(Calendar.class);
        TYPE_CLASSES_MAP.put(91, classList);
        classList = new ArrayList();
        classList.add(BigDecimal.class);
        TYPE_CLASSES_MAP.put(3, classList);
        classList = new ArrayList();
        classList.add(Double.class);
        TYPE_CLASSES_MAP.put(8, classList);
        classList = new ArrayList();
        classList.add(Double.class);
        classList.add(Float.class);
        TYPE_CLASSES_MAP.put(6, classList);
        classList = new ArrayList();
        classList.add(UUID.class);
        TYPE_CLASSES_MAP.put(-11, classList);
        classList = new ArrayList();
        classList.add(Long.class);
        classList.add(Integer.class);
        TYPE_CLASSES_MAP.put(4, classList);
        classList = new ArrayList();
        classList.add(BigDecimal.class);
        TYPE_CLASSES_MAP.put(2, classList);
        classList = new ArrayList();
        classList.add(Float.class);
        TYPE_CLASSES_MAP.put(7, classList);
        classList = new ArrayList();
        classList.add(Integer.class);
        classList.add(Short.class);
        TYPE_CLASSES_MAP.put(5, classList);
        classList = new ArrayList();
        classList.add(Time.class);
        classList.add(TimeTz.class);
        classList.add(java.util.Date.class);
        classList.add(Calendar.class);
        TYPE_CLASSES_MAP.put(92, classList);
        classList = new ArrayList();
        classList.add(Timestamp.class);
        classList.add(TimestampTz.class);
        classList.add(Date.class);
        classList.add(Time.class);
        classList.add(java.util.Date.class);
        classList.add(Calendar.class);
        TYPE_CLASSES_MAP.put(93, classList);
        classList = new ArrayList();
        classList.add(Short.class);
        classList.add(Byte.class);
        TYPE_CLASSES_MAP.put(-6, classList);
        classList = new ArrayList();
        classList.add(byte[].class);
        classList.add(ByteArrayInputStream.class);
        TYPE_CLASSES_MAP.put(-2, classList);
        classList = new ArrayList();
        classList.add(byte[].class);
        classList.add(ByteArrayInputStream.class);
        TYPE_CLASSES_MAP.put(-4, classList);
        classList = new ArrayList();
        classList.add(byte[].class);
        classList.add(ByteArrayInputStream.class);
        TYPE_CLASSES_MAP.put(-3, classList);
        classList = new ArrayList();
        classList.add(String.class);
        classList.add(java.util.Date.class);
        classList.add(Calendar.class);
        classList.add(BigInteger.class);
        TYPE_CLASSES_MAP.put(1, classList);
        classList = new ArrayList();
        classList.add(String.class);
        classList.add(java.util.Date.class);
        classList.add(Calendar.class);
        classList.add(BigInteger.class);
        TYPE_CLASSES_MAP.put(-1, classList);
        classList = new ArrayList();
        classList.add(String.class);
        classList.add(java.util.Date.class);
        classList.add(Calendar.class);
        classList.add(BigInteger.class);
        TYPE_CLASSES_MAP.put(12, classList);
        classList = new ArrayList();
        classList.add(Boolean.class);
        TYPE_CLASSES_MAP.put(16, classList);
        classList = new ArrayList();
        classList.add(String.class);
        TYPE_CLASSES_MAP.put(-8, classList);
        classList = new ArrayList();
        classList.add(String.class);
        TYPE_CLASSES_MAP.put(-9, classList);
        classList = new ArrayList();
        classList.add(String.class);
        TYPE_CLASSES_MAP.put(-10, classList);
        classList = new ArrayList();
        classList.add(DSITimeSpan.class);
        TYPE_CLASSES_MAP.put(103, classList);
        TYPE_CLASSES_MAP.put(108, classList);
        TYPE_CLASSES_MAP.put(109, classList);
        TYPE_CLASSES_MAP.put(110, classList);
        TYPE_CLASSES_MAP.put(104, classList);
        TYPE_CLASSES_MAP.put(111, classList);
        TYPE_CLASSES_MAP.put(112, classList);
        TYPE_CLASSES_MAP.put(105, classList);
        TYPE_CLASSES_MAP.put(113, classList);
        TYPE_CLASSES_MAP.put(106, classList);
        classList = new ArrayList();
        classList.add(DSIMonthSpan.class);
        TYPE_CLASSES_MAP.put(102, classList);
        TYPE_CLASSES_MAP.put(101, classList);
        TYPE_CLASSES_MAP.put(107, classList);
        classList = new ArrayList();
        classList.add(IArray.class);
        TYPE_CLASSES_MAP.put(2003, classList);
        classList = new ArrayList();
        classList.add(Struct.class);
        TYPE_CLASSES_MAP.put(2002, classList);
        classList = new ArrayList();
        classList.add(Object.class);
        TYPE_CLASSES_MAP.put(2000, classList);
        classList = new ArrayList();
        classList.add(Object.class);
        TYPE_CLASSES_MAP.put(1111, classList);
        classList = new ArrayList();
        classList.add(Object.class);
        TYPE_CLASSES_MAP.put(2012, classList);
    }

    public void copyData(DataWrapper other) {
        this.m_type = other.m_type;
        this.m_value = other.m_value;
        this.m_bigIntWasSetAsLongThroughSetData = other.m_bigIntWasSetAsLongThroughSetData;
    }

    public IArray getArray() throws IncorrectTypeException {
        if (2003 == this.m_type) {
            return (IArray)this.m_value;
        }
        throw new IncorrectTypeException();
    }

    public BigInteger getBigInt() throws IncorrectTypeException {
        if (-5 == this.m_type) {
            if (null == this.m_value || this.m_value instanceof BigInteger) {
                return (BigInteger)this.m_value;
            }
            return BigInteger.valueOf((Long)this.m_value);
        }
        throw new IncorrectTypeException();
    }

    public Long getBigIntAsLong() throws IncorrectTypeException {
        if (-5 == this.m_type) {
            if (this.m_value instanceof BigInteger) {
                BigInteger value = (BigInteger)this.m_value;
                return value.longValue();
            }
            return (Long)this.m_value;
        }
        throw new IncorrectTypeException();
    }

    public byte[] getBinary() throws IncorrectTypeException {
        if (-2 == this.m_type) {
            return this.getByteArray(this.m_value);
        }
        throw new IncorrectTypeException();
    }

    public Boolean getBit() throws IncorrectTypeException {
        if (-7 == this.m_type || 16 == this.m_type) {
            return (Boolean)this.m_value;
        }
        throw new IncorrectTypeException();
    }

    public Boolean getBoolean() throws IncorrectTypeException {
        if (-7 == this.m_type || 16 == this.m_type) {
            return (Boolean)this.m_value;
        }
        throw new IncorrectTypeException();
    }

    public String getChar() throws IncorrectTypeException {
        if (1 == this.m_type || -8 == this.m_type) {
            return (String)this.m_value;
        }
        throw new IncorrectTypeException();
    }

    public Date getDate() throws IncorrectTypeException {
        if (91 == this.m_type) {
            Date value = (Date)this.m_value;
            if (null == value) {
                return value;
            }
            Calendar local = Calendar.getInstance();
            local.setTimeInMillis(value.getTime());
            local.set(11, 0);
            local.set(12, 0);
            local.set(13, 0);
            local.set(14, 0);
            return new Date(local.getTimeInMillis());
        }
        throw new IncorrectTypeException();
    }

    public BigDecimal getDecimal() throws IncorrectTypeException {
        if (3 == this.m_type) {
            return (BigDecimal)this.m_value;
        }
        throw new IncorrectTypeException();
    }

    public Double getDouble() throws IncorrectTypeException {
        if (8 == this.m_type) {
            return (Double)this.m_value;
        }
        throw new IncorrectTypeException();
    }

    public Double getFloat() throws IncorrectTypeException {
        if (6 == this.m_type) {
            if (null == this.m_value || this.m_value instanceof Double) {
                return (Double)this.m_value;
            }
            return ((Float)this.m_value).floatValue();
        }
        throw new IncorrectTypeException();
    }

    public UUID getGuid() throws IncorrectTypeException {
        if (-11 == this.m_type) {
            return (UUID)this.m_value;
        }
        throw new IncorrectTypeException();
    }

    public Long getInteger() throws IncorrectTypeException {
        if (4 == this.m_type) {
            if (null == this.m_value || this.m_value instanceof Long) {
                return (Long)this.m_value;
            }
            return (long)((Integer)this.m_value);
        }
        throw new IncorrectTypeException();
    }

    public Object getInterval() throws IncorrectTypeException {
        if (TypeUtilities.isIntervalType(this.m_type)) {
            return this.m_value;
        }
        throw new IncorrectTypeException();
    }

    public byte[] getLongVarBinary() throws IncorrectTypeException {
        if (-4 == this.m_type) {
            return this.getByteArray(this.m_value);
        }
        throw new IncorrectTypeException();
    }

    public String getLongVarChar() throws IncorrectTypeException {
        if (-1 == this.m_type || -10 == this.m_type) {
            return (String)this.m_value;
        }
        throw new IncorrectTypeException();
    }

    public BigDecimal getNumeric() throws IncorrectTypeException {
        if (2 == this.m_type) {
            return (BigDecimal)this.m_value;
        }
        throw new IncorrectTypeException();
    }

    public Object getObject() {
        if (-5 == this.m_type && this.m_value instanceof Long && !this.m_bigIntWasSetAsLongThroughSetData) {
            this.m_value = BigInteger.valueOf((Long)this.m_value);
        }
        return this.m_value;
    }

    public Float getReal() throws IncorrectTypeException {
        if (7 == this.m_type) {
            return (Float)this.m_value;
        }
        throw new IncorrectTypeException();
    }

    public Integer getSmallInt() throws IncorrectTypeException {
        if (5 == this.m_type) {
            if (null == this.m_value || this.m_value instanceof Integer) {
                return (Integer)this.m_value;
            }
            return (int)((Short)this.m_value);
        }
        throw new IncorrectTypeException();
    }

    public Time getTime() throws IncorrectTypeException {
        if (92 == this.m_type) {
            if (this.m_value instanceof TimeTz) {
                TimeTz tz = (TimeTz)this.m_value;
                Calendar c = tz.getTimezoneCalendar();
                c.clear();
                c.setTimeInMillis(tz.getTime());
                c.set(1, 1970);
                c.set(2, 0);
                c.set(5, 1);
                return new TimeTz(c.getTimeInMillis(), c);
            }
            if (this.m_value instanceof Time) {
                Calendar local = Calendar.getInstance();
                local.setTimeInMillis(((Time)this.m_value).getTime());
                local.set(1, 1970);
                local.set(2, 0);
                local.set(5, 1);
                Time result = (Time)((Time)this.m_value).clone();
                result.setTime(local.getTimeInMillis());
                return result;
            }
            if (null == this.m_value) {
                return (Time)this.m_value;
            }
        }
        throw new IncorrectTypeException();
    }

    public Timestamp getTimestamp() throws IncorrectTypeException {
        if (93 == this.m_type) {
            return (Timestamp)this.m_value;
        }
        throw new IncorrectTypeException();
    }

    public TimestampTz getTimestampTz() throws IncorrectTypeException {
        if (93 == this.m_type) {
            if (null == this.m_value) {
                return null;
            }
            if (this.m_value instanceof Timestamp && !(this.m_value instanceof TimestampTz)) {
                return new TimestampTz((Timestamp)this.m_value, Calendar.getInstance());
            }
            return (TimestampTz)this.m_value;
        }
        throw new IncorrectTypeException();
    }

    public TimeTz getTimeTz() throws IncorrectTypeException {
        if (92 == this.m_type) {
            if (null == this.m_value) {
                return null;
            }
            if (this.m_value instanceof Time && !(this.m_value instanceof TimeTz)) {
                return new TimeTz((Time)this.m_value, Calendar.getInstance());
            }
            return (TimeTz)this.m_value;
        }
        throw new IncorrectTypeException();
    }

    public Short getTinyInt() throws IncorrectTypeException {
        if (-6 == this.m_type) {
            if (null == this.m_value || this.m_value instanceof Short) {
                return (Short)this.m_value;
            }
            return (short)((Byte)this.m_value);
        }
        throw new IncorrectTypeException();
    }

    public int getType() {
        return this.m_type;
    }

    public byte[] getVarBinary() throws IncorrectTypeException {
        if (-3 == this.m_type) {
            return this.getByteArray(this.m_value);
        }
        throw new IncorrectTypeException();
    }

    public String getVarChar() throws IncorrectTypeException {
        if (12 == this.m_type || -9 == this.m_type) {
            return (String)this.m_value;
        }
        throw new IncorrectTypeException();
    }

    public boolean isNull() {
        return null == this.m_value;
    }

    public boolean isSet() {
        return 0 != this.m_type;
    }

    public void setArray(IArray value) {
        this.m_type = 2003;
        this.m_value = value;
    }

    public void setBigInt(BigInteger value) {
        this.m_type = -5;
        this.m_value = value;
        this.m_bigIntWasSetAsLongThroughSetData = false;
    }

    public void setBigInt(long value) {
        this.m_type = -5;
        this.m_value = value;
        this.m_bigIntWasSetAsLongThroughSetData = false;
    }

    public void setBinary(byte[] value) {
        this.m_type = -2;
        this.m_value = value;
    }

    public void setBit(boolean value) {
        this.m_type = -7;
        this.m_value = value;
    }

    public void setBit(Boolean value) {
        this.m_type = -7;
        this.m_value = value;
    }

    public void setBoolean(boolean value) {
        this.m_type = 16;
        this.m_value = value;
    }

    public void setBoolean(Boolean value) {
        this.m_type = 16;
        this.m_value = value;
    }

    public void setChar(String value) {
        this.m_type = 1;
        this.m_value = value;
    }

    public void setData(int javaSqlType, Object data) throws IncorrectTypeException {
        if (null == data) {
            this.setNull(javaSqlType);
            return;
        }
        Object wrapperObject = data;
        if (TypeUtilities.isCharacterType(javaSqlType)) {
            if (data instanceof StringReader) {
                wrapperObject = this.getString((StringReader)data);
            } else if (data instanceof ByteArrayInputStream || data instanceof byte[]) {
                byte[] bytes = this.getByteArray(data);
                wrapperObject = TypeUtilities.isBinaryType(this.m_type) ? (Object)bytes : new String(bytes);
            } else {
                wrapperObject = data.toString();
            }
        } else if (TypeUtilities.isBinaryType(javaSqlType)) {
            wrapperObject = this.getByteArray(data);
        } else {
            List<Class<?>> expectedClasses = TYPE_CLASSES_MAP.get(javaSqlType);
            if (null == expectedClasses) {
                throw new IncorrectTypeException();
            }
            boolean foundClass = false;
            for (Class<?> expectedClass : expectedClasses) {
                if (!expectedClass.isInstance(wrapperObject)) continue;
                foundClass = true;
                break;
            }
            if (!foundClass) {
                throw new IncorrectTypeException();
            }
            if (-5 == javaSqlType) {
                this.m_bigIntWasSetAsLongThroughSetData = this.m_value instanceof Long;
            }
        }
        this.m_type = javaSqlType;
        if (93 == javaSqlType) {
            if (wrapperObject instanceof Time) {
                this.m_value = new Timestamp(((Time)wrapperObject).getTime());
            } else if (wrapperObject instanceof java.util.Date) {
                this.m_value = wrapperObject instanceof Timestamp ? wrapperObject : new Timestamp(((java.util.Date)wrapperObject).getTime());
            } else if (wrapperObject instanceof Calendar) {
                this.m_value = new Timestamp(((Calendar)wrapperObject).getTime().getTime());
            }
        } else {
            this.m_value = wrapperObject;
        }
    }

    public void setDate(int year, int month, int dayOfMonth) {
        this.m_type = 91;
        Calendar cal = Calendar.getInstance();
        cal.clear();
        if (year < 0) {
            year *= -1;
            cal.set(0, 0);
        }
        cal.set(year, month, dayOfMonth, 0, 0, 0);
        this.m_value = new Date(cal.getTimeInMillis());
    }

    public void setDate(Date value) {
        this.m_type = 91;
        this.m_value = value;
    }

    public void setDecimal(BigDecimal value) {
        this.m_type = 3;
        this.m_value = value;
    }

    public void setDouble(double value) {
        this.m_type = 8;
        this.m_value = new Double(value);
    }

    public void setDouble(Double value) {
        this.m_type = 8;
        this.m_value = value;
    }

    public void setFloat(double value) {
        this.m_type = 6;
        this.m_value = new Double(value);
    }

    public void setFloat(Double value) {
        this.m_type = 6;
        this.m_value = value;
    }

    public void setGuid(UUID value) {
        this.m_type = -11;
        this.m_value = value;
    }

    public void setInteger(long value) {
        this.m_type = 4;
        this.m_value = value;
    }

    public void setInteger(Long value) {
        this.m_type = 4;
        this.m_value = value;
    }

    public void setInterval(Object value) {
        if (value instanceof DSIMonthSpan) {
            this.m_type = ((DSIMonthSpan)value).getIntervalType();
            this.m_value = value;
        } else if (value instanceof DSITimeSpan) {
            this.m_type = ((DSITimeSpan)value).getIntervalType();
            this.m_value = value;
        }
    }

    public void setLongVarBinary(byte[] value) {
        this.m_type = -4;
        this.m_value = value;
    }

    public void setLongVarChar(String value) {
        this.m_type = -1;
        this.m_value = value;
    }

    public void setNull(int javaSqlType) {
        this.m_type = javaSqlType;
        this.m_value = null;
    }

    public void setNumeric(BigDecimal value) {
        this.m_type = 2;
        this.m_value = value;
    }

    public void setReal(float value) {
        this.m_type = 7;
        this.m_value = new Float(value);
    }

    public void setReal(Float value) {
        this.m_type = 7;
        this.m_value = value;
    }

    public void setSmallInt(int value) {
        this.m_type = 5;
        this.m_value = value;
    }

    public void setSmallInt(Integer value) {
        this.m_type = 5;
        this.m_value = value;
    }

    public void setTime(int hour, int minute, int second) {
        this.m_type = 92;
        Calendar cal = Calendar.getInstance();
        cal.set(1970, 0, 1, hour, minute, second);
        cal.set(14, 0);
        this.m_value = new Time(cal.getTimeInMillis());
    }

    public void setTime(int hour, int minute, int second, int fraction) {
        this.m_type = 92;
        Calendar cal = Calendar.getInstance();
        cal.set(1970, 0, 1, hour, minute, second);
        cal.set(14, fraction / 1000000);
        this.m_value = new Time(cal.getTimeInMillis());
    }

    public void setTime(Time value) {
        this.m_type = 92;
        this.m_value = value;
    }

    public void setTime(TimeTz value) {
        this.m_type = 92;
        this.m_value = value;
    }

    public void setTimestamp(int year, int month, int dayOfMonth, int hour, int minute, int second, int nanos) {
        this.m_type = 93;
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        if (year < 0) {
            year *= -1;
            calendar.set(0, 0);
        }
        calendar.set(year, month, dayOfMonth);
        calendar.set(11, hour);
        calendar.set(12, minute);
        calendar.set(13, second);
        Timestamp timestamp = new Timestamp(calendar.getTimeInMillis());
        timestamp.setNanos(nanos);
        this.m_value = timestamp;
    }

    public void setTimestamp(Timestamp value) {
        this.m_type = 93;
        this.m_value = value;
    }

    public void setTimestamp(TimestampTz value) {
        this.m_type = 93;
        this.m_value = value;
    }

    public void setTinyInt(short value) {
        this.m_type = -6;
        this.m_value = value;
    }

    public void setTinyInt(Short value) {
        this.m_type = -6;
        this.m_value = value;
    }

    public void setVarBinary(byte[] value) {
        this.m_type = -3;
        this.m_value = value;
    }

    public void setVarChar(String value) {
        this.m_type = 12;
        this.m_value = value;
    }

    public void setWVarChar(String value) {
        this.m_type = -9;
        this.m_value = value;
    }

    public void setWChar(String value) {
        this.m_type = -8;
        this.m_value = value;
    }

    public void setWLongVarChar(String value) {
        this.m_type = -10;
        this.m_value = value;
    }

    public String toString() {
        StringBuilder stringValue = new StringBuilder();
        stringValue.append(this.m_type);
        stringValue.append("|");
        if (this.isNull()) {
            stringValue.append("null");
        } else {
            stringValue.append(this.m_value.toString());
        }
        return stringValue.toString();
    }

    private byte[] getByteArray(Object m_value) throws IncorrectTypeException {
        if (null == m_value || m_value instanceof byte[]) {
            return (byte[])m_value;
        }
        if (m_value instanceof ByteArrayInputStream) {
            ByteArrayInputStream is = (ByteArrayInputStream)m_value;
            byte[] bytes = new byte[is.available()];
            try {
                is.read(bytes);
            }
            catch (IOException e) {
                return null;
            }
            return bytes;
        }
        throw new IncorrectTypeException();
    }

    private String getString(Reader reader) {
        BufferedReader rdr = new BufferedReader(reader);
        StringBuffer buffer = new StringBuffer();
        try {
            int ch = 0;
            while (-1 != (ch = ((Reader)rdr).read())) {
                buffer.append((char)ch);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return buffer.toString();
    }

    private final byte[] getCharAsUTF8() {
        return ((String)this.m_value).getBytes(UTF8_CHARSET);
    }

    private final byte[] getVarCharAsUTF8() throws IncorrectTypeException {
        return ((String)this.m_value).getBytes(UTF8_CHARSET);
    }

    private final byte[] getLongVarCharAsUTF8() throws IncorrectTypeException {
        return ((String)this.m_value).getBytes(UTF8_CHARSET);
    }

    private final void setCharWithUTF8(byte[] value) {
        this.m_type = 1;
        this.m_value = null != value ? new String(value, UTF8_CHARSET) : null;
    }

    private final void setVarCharWithUTF8(byte[] value) {
        this.m_type = 12;
        this.m_value = null != value ? new String(value, UTF8_CHARSET) : null;
    }

    private final void setLongVarCharWithUTF8(byte[] value) {
        this.m_type = -1;
        this.m_value = null != value ? new String(value, UTF8_CHARSET) : null;
    }

    private final String getUnsignedBigintAsString() {
        return this.m_value.toString();
    }

    private final long getSignedBigint() {
        return ((Number)this.m_value).longValue();
    }

    private final boolean getBitPrimitive() {
        return (Boolean)this.m_value;
    }

    private final double getDoublePrimitive() {
        return ((Number)this.m_value).doubleValue();
    }

    private final double getFloatPrimitive() {
        return ((Number)this.m_value).doubleValue();
    }

    private final long getUnsignedInteger() {
        return ((Number)this.m_value).longValue();
    }

    private final int getSignedInteger() {
        return ((Number)this.m_value).intValue();
    }

    private final float getRealPrimitive() {
        return ((Number)this.m_value).floatValue();
    }

    private final int getUnsignedSmallint() {
        return ((Number)this.m_value).intValue();
    }

    private final short getSignedSmallint() {
        return ((Number)this.m_value).shortValue();
    }

    private final short getUnsignedTinyint() {
        return ((Number)this.m_value).shortValue();
    }

    private final byte getSignedTinyint() {
        return ((Number)this.m_value).byteValue();
    }

    private final void setMonthSpan(int intervalSqlType, int year, int month, boolean isNegative) {
        this.m_value = new DSIMonthSpan(intervalSqlType, year, month, isNegative);
        this.m_type = intervalSqlType;
    }

    private final void setTimeSpan(int intervalSqlType, int day, int hour, int minute, int second, int fraction, boolean isNegative) {
        this.m_value = new DSITimeSpan(intervalSqlType, day, hour, minute, second, fraction, isNegative);
        this.m_type = intervalSqlType;
    }

    private final void setTimestamp(long seconds, int nanos) {
        long millis = seconds * 1000L;
        TimeZone tz = Calendar.getInstance().getTimeZone();
        int zoneOffset = tz.getOffset(millis - (long)tz.getRawOffset());
        millis -= (long)zoneOffset;
        if (93 == this.m_type && null != this.m_value) {
            ((Timestamp)this.m_value).setTime(millis);
        } else {
            this.m_value = new Timestamp(millis);
            this.m_type = 93;
        }
        ((Timestamp)this.m_value).setNanos(nanos);
    }

    private final void setUnsignedBigInt(long value) {
        this.setBigInt(BigInteger.valueOf(value).and(ConverterConstants.UNSIGNED_BIGINT_MAX));
    }

    private final void unpackDate(long nativeDataPtr) throws IncorrectTypeException {
        assert (0L != nativeDataPtr) : "The given native pointer should not be NULL.";
        if (91 != this.m_type) {
            throw new IncorrectTypeException();
        }
        Date value = (Date)this.m_value;
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.setTimeInMillis(value.getTime());
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        boolean isNegative = cal.get(0) == 0;
        int year = isNegative ? cal.get(1) * -1 : cal.get(1);
        int month = cal.get(2) + 1;
        int date = cal.get(5);
        this.unpackDateNative(nativeDataPtr, year, month, date);
    }

    private final native void unpackDateNative(long var1, int var3, int var4, int var5);

    private final void unpackTime(long nativeDataPtr) throws IncorrectTypeException {
        Time value;
        assert (0L != nativeDataPtr) : "The given native pointer should not be NULL.";
        Calendar cal = Calendar.getInstance();
        if (92 == this.m_type) {
            value = (Time)this.m_value;
            if (this.m_value instanceof TimeTz) {
                cal = ((TimeTz)this.m_value).getTimezoneCalendar();
                cal.clear();
            }
        } else {
            throw new IncorrectTypeException();
        }
        cal.setTimeInMillis(value.getTime());
        this.unpackTimeNative(nativeDataPtr, cal.get(11), cal.get(12), cal.get(13), cal.get(14) * 1000000);
    }

    private final native void unpackTimeNative(long var1, int var3, int var4, int var5, int var6);

    private final void unpackTimestamp(long nativeDataPtr) throws IncorrectTypeException {
        assert (0L != nativeDataPtr) : "The given native pointer should not be NULL.";
        Timestamp value = this.getTimestamp();
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.setTimeInMillis(value.getTime());
        boolean isNegative = cal.get(0) == 0;
        int year = isNegative ? cal.get(1) * -1 : cal.get(1);
        int month = cal.get(2) + 1;
        int date = cal.get(5);
        int hour = cal.get(11);
        int minute = cal.get(12);
        int second = cal.get(13);
        int fraction = value.getNanos();
        this.unpackTimestampNative(nativeDataPtr, year, month, date, hour, minute, second, fraction);
    }

    private final native void unpackTimestampNative(long var1, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

    private final void unpackInterval(long nativeDataPtr) {
        assert (0L != nativeDataPtr) : "The given native pointer should not be NULL.";
        assert (null != this.m_value) : "The stored value should be non-null.";
        switch (this.m_type) {
            case 101: 
            case 102: 
            case 107: {
                DSIMonthSpan monthSpan = (DSIMonthSpan)this.m_value;
                DataWrapper.unpackMonthSpan(nativeDataPtr, this.m_type, monthSpan.getYear(), monthSpan.getMonth(), monthSpan.isNegative());
                break;
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: {
                DSITimeSpan timeSpan = (DSITimeSpan)this.m_value;
                DataWrapper.unpackTimeSpan(nativeDataPtr, this.m_type, timeSpan.getDay(), timeSpan.getHour(), timeSpan.getMinute(), timeSpan.getSecond(), timeSpan.getFraction(), timeSpan.isNegative());
                break;
            }
            default: {
                assert (false) : this.m_type + " is not an interval type!";
                break;
            }
        }
    }

    private static final native void unpackMonthSpan(long var0, int var2, int var3, int var4, boolean var5);

    private static final native void unpackTimeSpan(long var0, int var2, int var3, int var4, int var5, int var6, int var7, boolean var8);

    static {
        DataWrapper.addTypeClassesMap();
        UTF8_CHARSET = Charset.forName("UTF-8");
    }
}

