/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.dsi.dataengine.impl;

import com.vertica.dsi.core.impl.DSIDriver;
import com.vertica.dsi.dataengine.interfaces.IMetadataSource;
import com.vertica.dsi.dataengine.utilities.DSITypeUtilities;
import com.vertica.dsi.dataengine.utilities.DataWrapper;
import com.vertica.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.vertica.dsi.exceptions.InvalidArgumentException;
import com.vertica.dsi.utilities.DSIMessageKey;
import com.vertica.support.ILogger;
import com.vertica.support.LogUtilities;
import com.vertica.support.exceptions.ErrorException;
import com.vertica.support.exceptions.ExceptionType;
import java.util.ArrayList;
import java.util.List;

public class DSITableTypeOnlyMetadataSource
implements IMetadataSource {
    private boolean m_isFetching = false;
    private int m_currentIndex = 0;
    List<String> m_tableTypes = new ArrayList<String>();
    private ILogger m_logger;

    public DSITableTypeOnlyMetadataSource(ILogger logger) {
        LogUtilities.logFunctionEntrance(logger, logger);
        this.m_logger = logger;
        this.m_tableTypes.add("SYSTEM TABLE");
        this.m_tableTypes.add("TABLE");
        this.m_tableTypes.add("VIEW");
    }

    public DSITableTypeOnlyMetadataSource(ILogger logger, List<String> tableTypes) {
        LogUtilities.logFunctionEntrance(logger, logger, tableTypes);
        if (null == tableTypes) {
            throw new InvalidArgumentException(2, "tableTypes");
        }
        this.m_logger = logger;
        this.m_tableTypes = tableTypes;
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        try {
            this.closeCursor();
        }
        catch (ErrorException errorException) {
            // empty catch block
        }
    }

    @Override
    public void closeCursor() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_isFetching = false;
    }

    @Override
    public boolean getMetadata(MetadataSourceColumnTag columnTag, long offset, long maxSize, DataWrapper data) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[]{columnTag, offset, maxSize});
        switch (columnTag) {
            case TABLE_TYPE: {
                return DSITypeUtilities.outputVarCharStringData(this.m_tableTypes.get(this.m_currentIndex), data, offset, maxSize);
            }
        }
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_COLNUM.name(), new String[]{columnTag.toString()}, ExceptionType.DEFAULT);
    }

    @Override
    public boolean hasMoreRows() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return this.m_currentIndex + 1 < this.m_tableTypes.size();
    }

    @Override
    public boolean moveToNextRow() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (this.m_isFetching) {
            ++this.m_currentIndex;
        } else {
            this.m_isFetching = true;
            this.m_currentIndex = 0;
        }
        return this.m_currentIndex < this.m_tableTypes.size();
    }
}

