/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public enum CollectSupportDataOutputStream {
    STANDARD_OUTPUT("stdout", 0),
    STANDARD_ERROR("stderr", 1);

    private final int intValue;
    private final String name;

    private CollectSupportDataOutputStream(String name, int intValue) {
        this.name = name;
        this.intValue = intValue;
    }

    public String getName() {
        return this.name;
    }

    public int getIntValue() {
        return this.intValue;
    }

    public static CollectSupportDataOutputStream forName(String name) {
        String lowerName;
        switch (lowerName = StaticUtils.toLowerCase(name).replace('-', '_')) {
            case "stdout": 
            case "std-out": 
            case "standardout": 
            case "standard_out": 
            case "standardoutput": 
            case "standard_output": {
                return STANDARD_OUTPUT;
            }
            case "stderr": 
            case "std-err": 
            case "standarderr": 
            case "standard_err": 
            case "standarderror": 
            case "standard_error": {
                return STANDARD_ERROR;
            }
        }
        return null;
    }

    public static CollectSupportDataOutputStream forIntValue(int intValue) {
        for (CollectSupportDataOutputStream os : CollectSupportDataOutputStream.values()) {
            if (os.intValue != intValue) continue;
            return os;
        }
        return null;
    }

    public String toString() {
        return this.name;
    }
}

