/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.jasper.servlet;

import com.tongweb.commons.logger.logging.Log;
import com.tongweb.commons.logger.logging.LogFactory;
import com.tongweb.jasper.compiler.Localizer;
import com.tongweb.jasper.compiler.TldCache;
import com.tongweb.jasper.runtime.JspFactoryImpl;
import com.tongweb.jasper.security.SecurityClassLoad;
import com.tongweb.jasper.servlet.TldScanner;
import com.tongweb.web.InstanceManager;
import com.tongweb.web.SimpleInstanceManager;
import java.io.IOException;
import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.jsp.JspFactory;
import org.xml.sax.SAXException;

public class JasperInitializer
implements ServletContainerInitializer {
    private static final String MSG = "com.tongweb.jasper.servlet.JasperInitializer";
    private final Log log = LogFactory.getLog(JasperInitializer.class);

    public void onStartup(Set<Class<?>> types, ServletContext context) throws ServletException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)Localizer.getMessage("com.tongweb.jasper.servlet.JasperInitializer.onStartup", context.getServletContextName()));
        }
        if (context.getAttribute(InstanceManager.class.getName()) == null) {
            context.setAttribute(InstanceManager.class.getName(), (Object)new SimpleInstanceManager());
        }
        boolean validate = Boolean.parseBoolean(context.getInitParameter("com.tongweb.jasper.XML_VALIDATE_TLD"));
        String blockExternalString = context.getInitParameter("com.tongweb.jasper.XML_BLOCK_EXTERNAL");
        boolean blockExternal = blockExternalString == null ? true : Boolean.parseBoolean(blockExternalString);
        TldScanner scanner = this.newTldScanner(context, true, validate, blockExternal);
        try {
            scanner.scan();
        }
        catch (IOException | SAXException e) {
            throw new ServletException((Throwable)e);
        }
        for (String listener : scanner.getListeners()) {
            context.addListener(listener);
        }
        context.setAttribute(TldCache.SERVLET_CONTEXT_ATTRIBUTE_NAME, (Object)new TldCache(context, scanner.getUriTldResourcePathMap(), scanner.getTldResourcePathTaglibXmlMap()));
    }

    protected TldScanner newTldScanner(ServletContext context, boolean namespaceAware, boolean validate, boolean blockExternal) {
        return new TldScanner(context, namespaceAware, validate, blockExternal);
    }

    static {
        JspFactoryImpl factory = new JspFactoryImpl();
        SecurityClassLoad.securityClassLoad(((Object)((Object)factory)).getClass().getClassLoader());
        if (JspFactory.getDefaultFactory() == null) {
            JspFactory.setDefaultFactory((JspFactory)factory);
        }
    }
}

