/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.web.util.threads;

import com.tongweb.commons.logger.logging.Log;
import com.tongweb.commons.logger.logging.LogFactory;
import com.tongweb.web.util.threads.StopPooledThreadException;

public class TaskThread
extends Thread {
    private static final Log log = LogFactory.getLog(TaskThread.class);
    private final long creationTime = System.currentTimeMillis();

    public TaskThread(ThreadGroup group, Runnable target, String name) {
        super(group, new WrappingRunnable(target), name);
    }

    public TaskThread(ThreadGroup group, Runnable target, String name, long stackSize) {
        super(group, new WrappingRunnable(target), name, stackSize);
    }

    public final long getCreationTime() {
        return this.creationTime;
    }

    private static class WrappingRunnable
    implements Runnable {
        private Runnable wrappedRunnable;

        WrappingRunnable(Runnable wrappedRunnable) {
            this.wrappedRunnable = wrappedRunnable;
        }

        @Override
        public void run() {
            try {
                this.wrappedRunnable.run();
            }
            catch (StopPooledThreadException exc) {
                log.debug((Object)"Thread exiting on purpose", (Throwable)exc);
            }
        }
    }
}

