/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.web.util.net.gmjsse;

import com.tongweb.commons.logger.logging.Log;
import com.tongweb.commons.logger.logging.LogFactory;
import com.tongweb.web.util.file.ConfigFileLoader;
import com.tongweb.web.util.net.SSLContext;
import com.tongweb.web.util.net.SSLHostConfig;
import com.tongweb.web.util.net.SSLHostConfigCertificate;
import com.tongweb.web.util.net.SSLUtilBase;
import com.tongweb.web.util.net.gmjsse.GMConstant;
import com.tongweb.web.util.net.gmjsse.GMSSLContext;
import com.tongweb.web.util.net.gmjsse.GMTrustManager;
import com.tongweb.web.util.res.StringManager;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;

public class GMUtil
extends SSLUtilBase {
    public static final boolean DEBUG = false;
    private static final Log log = LogFactory.getLog(GMUtil.class);
    private static final StringManager sm = StringManager.getManager(GMUtil.class);
    private static final Set<String> implementedProtocols;
    private static final Set<String> implementedCiphers;
    private SSLHostConfigCertificate conf = null;

    public GMUtil(SSLHostConfigCertificate certificate) {
        this(certificate, true);
    }

    public GMUtil(SSLHostConfigCertificate certificate, boolean warnOnSkip) {
        super(certificate, warnOnSkip);
        this.conf = certificate;
    }

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    public KeyManager[] getKeyManagers() {
        SSLHostConfig sslHostConfig = this.conf.getSSLHostConfig();
        String sigKeystoreFile = this.conf.getCertificateKeystoreFile();
        String sigKeystorePass = this.conf.getCertificateKeystorePassword();
        String encKeystoreFile = sslHostConfig.getTruststoreFile();
        String encKeystorePass = sslHostConfig.getTruststorePassword();
        String keystoreType = this.conf.getCertificateKeystoreType();
        KeyManager[] km = null;
        try {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
            keyManagerFactory.init(null, null);
            km = keyManagerFactory.getKeyManagers();
            Class<?> clzz = Class.forName("com.tongweb.gmssl.jsse.security.ssl.SunX509KeyManagerImpl");
            Object o = clzz.newInstance();
            Method init = clzz.getMethod("init", String.class, InputStream.class, String.class, InputStream.class, String.class);
            Object invoke = init.invoke(o, keystoreType, ConfigFileLoader.getInputStream(sigKeystoreFile), sigKeystorePass, ConfigFileLoader.getInputStream(encKeystoreFile), encKeystorePass);
            km = new KeyManager[]{(KeyManager)invoke};
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return km;
    }

    @Override
    public TrustManager[] getTrustManagers() throws Exception {
        return new TrustManager[]{new GMTrustManager()};
    }

    @Override
    protected Set<String> getImplementedProtocols() {
        return implementedProtocols;
    }

    @Override
    protected Set<String> getImplementedCiphers() {
        return implementedCiphers;
    }

    @Override
    public String[] getEnabledProtocols() {
        String[] protocols = super.getEnabledProtocols();
        String[] gmProtocls = new String[protocols.length + 2];
        for (int i = 0; i < protocols.length; ++i) {
            gmProtocls[i] = protocols[i];
        }
        gmProtocls[protocols.length] = GMConstant.GM_PROTOCOL;
        gmProtocls[protocols.length + 1] = "TLSv1.2";
        return gmProtocls;
    }

    @Override
    public String[] getEnabledCiphers() {
        int i;
        String[] ciphers = super.getEnabledCiphers();
        Vector<String> vector = new Vector<String>();
        for (i = 0; i < ciphers.length; ++i) {
            if (ciphers[i].indexOf("ECDSA") != -1 || ciphers[i].indexOf("_DSS_") != -1) continue;
            vector.addElement(ciphers[i]);
        }
        vector.addAll(GMConstant.CIPHERS);
        ciphers = new String[vector.size()];
        for (i = 0; i < vector.size(); ++i) {
            ciphers[i] = (String)vector.elementAt(i);
        }
        return ciphers;
    }

    @Override
    protected boolean isTls13RenegAuthAvailable() {
        return false;
    }

    @Override
    public SSLContext createSSLContextInternal(List<String> paramList) throws Exception {
        return new GMSSLContext(this.sslHostConfig.getSslProtocol());
    }

    static {
        GMSSLContext context = null;
        try {
            context = new GMSSLContext(GMConstant.GM_PROTOCOL, GMConstant.GM_PROVIDER);
            context.init(null, null, null);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        String[] implementedProtocolsArray = context.getSupportedSSLParameters().getProtocols();
        implementedProtocols = new HashSet<String>(implementedProtocolsArray.length);
        for (int b = 0; b < implementedProtocolsArray.length; ++b) {
            String protocol = implementedProtocolsArray[b];
            String protocolUpper = protocol.toUpperCase(Locale.ENGLISH);
            if (!"SSLV2HELLO".equals(protocolUpper) && !"SSLV3".equals(protocolUpper) && protocolUpper.contains("SSL")) {
                log.debug((Object)sm.getString("jsse.excludeProtocol", protocol));
                continue;
            }
            implementedProtocols.add(protocol);
        }
        if (implementedProtocols.size() == 0) {
            log.warn((Object)sm.getString("jsse.noDefaultProtocols"));
        }
        String[] implementedCipherSuiteArray = context.getSupportedSSLParameters().getCipherSuites();
        implementedCiphers = new HashSet<String>(implementedCipherSuiteArray.length);
        implementedCiphers.addAll(Arrays.asList(implementedCipherSuiteArray));
    }
}

