/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.web.util.http.parser;

import com.tongweb.web.util.http.parser.HttpParser;
import com.tongweb.web.util.http.parser.SkipResult;
import java.io.IOException;
import java.io.StringReader;

public class ContentRange {
    private final String units;
    private final long start;
    private final long end;
    private final long length;

    public ContentRange(String units, long start, long end, long length) {
        this.units = units;
        this.start = start;
        this.end = end;
        this.length = length;
    }

    public String getUnits() {
        return this.units;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public long getLength() {
        return this.length;
    }

    public static ContentRange parse(StringReader input) throws IOException {
        String units = HttpParser.readToken(input);
        if (units == null || units.length() == 0) {
            return null;
        }
        if (HttpParser.skipConstant(input, "=") == SkipResult.NOT_FOUND) {
            return null;
        }
        long start = HttpParser.readLong(input);
        if (HttpParser.skipConstant(input, "-") == SkipResult.NOT_FOUND) {
            return null;
        }
        long end = HttpParser.readLong(input);
        if (HttpParser.skipConstant(input, "/") == SkipResult.NOT_FOUND) {
            return null;
        }
        long length = HttpParser.readLong(input);
        SkipResult skipResult = HttpParser.skipConstant(input, "X");
        if (skipResult != SkipResult.EOF) {
            return null;
        }
        return new ContentRange(units, start, end, length);
    }
}

