/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.web.dbcp.pool2.impl;

import com.tongweb.web.dbcp.pool2.PooledObject;
import com.tongweb.web.dbcp.pool2.PooledObjectState;
import com.tongweb.web.dbcp.pool2.impl.DefaultPooledObject;
import com.tongweb.web.dbcp.pool2.impl.GenericObjectPool;
import java.util.Map;

public class PoolLeakChecker
implements Runnable {
    private GenericObjectPool genericObjectPool;

    PoolLeakChecker(GenericObjectPool genericObjectPool) {
        this.genericObjectPool = genericObjectPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Map allObjects = this.genericObjectPool.getAllObjects();
        long now = System.currentTimeMillis();
        long timeout = now - (long)this.genericObjectPool.getRemoveAbandonedTimeout() * 1000L;
        Map map = allObjects;
        synchronized (map) {
            for (PooledObject pooledObject : allObjects.values()) {
                DefaultPooledObject defaultPooledObject = (DefaultPooledObject)pooledObject;
                if (defaultPooledObject.getState() != PooledObjectState.ALLOCATED || defaultPooledObject.getLastUsedTime() > timeout || defaultPooledObject.isAlreadyPrintLog()) continue;
                defaultPooledObject.printStackTrace(this.genericObjectPool.getAbandonedConfig().getLogWriter());
                defaultPooledObject.setAlreadyPrintLog(true);
            }
        }
    }
}

