/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.web.dbcp.pool2.impl;

import com.tongweb.web.dbcp.pool2.DestroyMode;
import com.tongweb.web.dbcp.pool2.PooledObject;
import com.tongweb.web.dbcp.pool2.PooledObjectState;
import com.tongweb.web.dbcp.pool2.impl.AbandonedConfig;
import com.tongweb.web.dbcp.pool2.impl.DefaultPooledObject;
import com.tongweb.web.dbcp.pool2.impl.GenericObjectPool;
import java.util.ArrayList;
import java.util.Map;

public class PoolCleaner
implements Runnable {
    private GenericObjectPool genericObjectPool;
    private AbandonedConfig abandonedConfig;

    PoolCleaner(GenericObjectPool genericObjectPool, AbandonedConfig abandonedConfig) {
        this.genericObjectPool = genericObjectPool;
        this.abandonedConfig = abandonedConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Map allObjects = this.genericObjectPool.getAllObjects();
        if (!this.abandonedConfig.getRemoveAbandonedOnBorrow()) {
            return;
        }
        long now = System.currentTimeMillis();
        long timeout = now - (long)this.genericObjectPool.getRemoveAbandonedTimeout() * 1000L;
        ArrayList remove = new ArrayList();
        Map map = allObjects;
        synchronized (map) {
            for (PooledObject pooledObject : allObjects.values()) {
                DefaultPooledObject defaultPooledObject = (DefaultPooledObject)pooledObject;
                if (defaultPooledObject.getState() != PooledObjectState.ALLOCATED || defaultPooledObject.getLastUsedTime() > timeout) continue;
                defaultPooledObject.markAbandoned();
                remove.add(pooledObject);
                if (defaultPooledObject.isAlreadyPrintLog()) continue;
                defaultPooledObject.printStackTrace(this.genericObjectPool.getAbandonedConfig().getLogWriter());
                defaultPooledObject.setAlreadyPrintLog(true);
            }
        }
        for (PooledObject pooledObject : remove) {
            try {
                this.genericObjectPool.invalidateObject(pooledObject.getObject(), DestroyMode.ABANDONED);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

