/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.web.dbcp.dbcp2.interceptor.com;

import com.tongweb.commons.logger.logging.Log;
import com.tongweb.commons.logger.logging.LogFactory;
import com.tongweb.web.dbcp.dbcp2.DelegatingStatement;
import com.tongweb.web.dbcp.dbcp2.interceptor.com.StatementProxy;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;

public class StatementInterceptor
implements InvocationHandler {
    private static final Log log = LogFactory.getLog(DelegatingStatement.class);
    private Object obj;
    private Boolean sqlLog = Boolean.getBoolean("sql-log");
    private Integer excuteTime = Integer.parseInt(System.getProperty("log-on-excute-time", "1000"));

    public StatementInterceptor(Object obj) {
        this.obj = obj;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (args == null) {
            return null;
        }
        long timebegin = System.currentTimeMillis();
        Object invoke = method.invoke(this.obj, args);
        StatementProxy statementProxy = (StatementProxy)this.obj;
        Statement statement = statementProxy.getStatement();
        if (statement instanceof DelegatingStatement) {
            this.sqlLog(args, System.currentTimeMillis() - timebegin);
        }
        return invoke;
    }

    public void sqlLog(Object[] args, long cost) {
        String tsDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss ").format(new Date(System.currentTimeMillis()));
        String sql = Arrays.toString(args);
        String mes = tsDate + "  [SQL execute " + cost + " ms : " + sql + "]";
        if (this.sqlLog.booleanValue() && cost > (long)this.excuteTime.intValue()) {
            SimpleDateFormat fileDateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH", Locale.US);
            String fileName = "sql_" + fileDateFormatter.format(new Date(System.currentTimeMillis())) + ".log";
            File file = new File(System.getProperty("tongweb.home") + File.separator + "logs" + File.separator + fileName);
            try {
                FileOutputStream out = new FileOutputStream(file, true);
                PrintWriter printWriter = new PrintWriter(out);
                printWriter.println(mes);
                printWriter.flush();
            }
            catch (IOException e) {
                log.error((Object)e.getMessage());
            }
        }
    }
}

