/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.web.dbcp.dbcp2;

import com.tongweb.web.dbcp.dbcp2.PoolingConnection;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Objects;

public class PStmtKey {
    private final String sql;
    private final Integer resultSetType;
    private final Integer resultSetConcurrency;
    private final Integer resultSetHoldability;
    private final String catalog;
    private final String schema;
    private final Integer autoGeneratedKeys;
    private final int[] columnIndexes;
    private final String[] columnNames;
    private final PoolingConnection.StatementType statementType;
    private transient StatementBuilder builder;

    @Deprecated
    public PStmtKey(String sql) {
        this(sql, null, PoolingConnection.StatementType.PREPARED_STATEMENT);
    }

    @Deprecated
    public PStmtKey(String sql, int resultSetType, int resultSetConcurrency) {
        this(sql, null, resultSetType, resultSetConcurrency, PoolingConnection.StatementType.PREPARED_STATEMENT);
    }

    @Deprecated
    public PStmtKey(String sql, String catalog) {
        this(sql, catalog, PoolingConnection.StatementType.PREPARED_STATEMENT);
    }

    @Deprecated
    public PStmtKey(String sql, String catalog, int autoGeneratedKeys) {
        this(sql, catalog, PoolingConnection.StatementType.PREPARED_STATEMENT, (Integer)autoGeneratedKeys);
    }

    @Deprecated
    public PStmtKey(String sql, String catalog, int resultSetType, int resultSetConcurrency) {
        this(sql, catalog, resultSetType, resultSetConcurrency, PoolingConnection.StatementType.PREPARED_STATEMENT);
    }

    @Deprecated
    public PStmtKey(String sql, String catalog, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        this(sql, catalog, resultSetType, resultSetConcurrency, resultSetHoldability, PoolingConnection.StatementType.PREPARED_STATEMENT);
    }

    @Deprecated
    public PStmtKey(String sql, String catalog, int resultSetType, int resultSetConcurrency, int resultSetHoldability, PoolingConnection.StatementType statementType) {
        this.sql = sql;
        this.catalog = catalog;
        this.schema = null;
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.resultSetHoldability = resultSetHoldability;
        this.statementType = statementType;
        this.autoGeneratedKeys = null;
        this.columnIndexes = null;
        this.columnNames = null;
        if (statementType == PoolingConnection.StatementType.PREPARED_STATEMENT) {
            this.builder = new PreparedStatementWithResultSetHoldability();
        } else if (statementType == PoolingConnection.StatementType.CALLABLE_STATEMENT) {
            this.builder = new PreparedCallWithResultSetHoldability();
        }
    }

    @Deprecated
    public PStmtKey(String sql, String catalog, int resultSetType, int resultSetConcurrency, PoolingConnection.StatementType statementType) {
        this.sql = sql;
        this.catalog = catalog;
        this.schema = null;
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.resultSetHoldability = null;
        this.statementType = statementType;
        this.autoGeneratedKeys = null;
        this.columnIndexes = null;
        this.columnNames = null;
        if (statementType == PoolingConnection.StatementType.PREPARED_STATEMENT) {
            this.builder = new PreparedStatementWithResultSetConcurrency();
        } else if (statementType == PoolingConnection.StatementType.CALLABLE_STATEMENT) {
            this.builder = new PreparedCallWithResultSetConcurrency();
        }
    }

    @Deprecated
    public PStmtKey(String sql, String catalog, int[] columnIndexes) {
        this.sql = sql;
        this.catalog = catalog;
        this.schema = null;
        this.statementType = PoolingConnection.StatementType.PREPARED_STATEMENT;
        this.autoGeneratedKeys = null;
        this.columnIndexes = columnIndexes == null ? null : Arrays.copyOf(columnIndexes, columnIndexes.length);
        this.columnNames = null;
        this.resultSetType = null;
        this.resultSetConcurrency = null;
        this.resultSetHoldability = null;
        this.builder = new PreparedStatementWithColumnIndexes();
    }

    @Deprecated
    public PStmtKey(String sql, String catalog, PoolingConnection.StatementType statementType) {
        this.sql = sql;
        this.catalog = catalog;
        this.schema = null;
        this.statementType = statementType;
        this.autoGeneratedKeys = null;
        this.columnIndexes = null;
        this.columnNames = null;
        this.resultSetType = null;
        this.resultSetConcurrency = null;
        this.resultSetHoldability = null;
        if (statementType == PoolingConnection.StatementType.PREPARED_STATEMENT) {
            this.builder = new PreparedStatementSQL();
        } else if (statementType == PoolingConnection.StatementType.CALLABLE_STATEMENT) {
            this.builder = new PreparedCallSQL();
        }
    }

    @Deprecated
    public PStmtKey(String sql, String catalog, PoolingConnection.StatementType statementType, Integer autoGeneratedKeys) {
        this.sql = sql;
        this.catalog = catalog;
        this.schema = null;
        this.statementType = statementType;
        this.autoGeneratedKeys = autoGeneratedKeys;
        this.columnIndexes = null;
        this.columnNames = null;
        this.resultSetType = null;
        this.resultSetConcurrency = null;
        this.resultSetHoldability = null;
        if (statementType == PoolingConnection.StatementType.PREPARED_STATEMENT) {
            this.builder = new PreparedStatementWithAutoGeneratedKeys();
        } else if (statementType == PoolingConnection.StatementType.CALLABLE_STATEMENT) {
            this.builder = new PreparedCallSQL();
        }
    }

    public PStmtKey(String sql, String catalog, String schema) {
        this(sql, catalog, schema, PoolingConnection.StatementType.PREPARED_STATEMENT);
    }

    public PStmtKey(String sql, String catalog, String schema, int autoGeneratedKeys) {
        this(sql, catalog, schema, PoolingConnection.StatementType.PREPARED_STATEMENT, (Integer)autoGeneratedKeys);
    }

    public PStmtKey(String sql, String catalog, String schema, int resultSetType, int resultSetConcurrency) {
        this(sql, catalog, schema, resultSetType, resultSetConcurrency, PoolingConnection.StatementType.PREPARED_STATEMENT);
    }

    public PStmtKey(String sql, String catalog, String schema, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        this(sql, catalog, schema, resultSetType, resultSetConcurrency, resultSetHoldability, PoolingConnection.StatementType.PREPARED_STATEMENT);
    }

    public PStmtKey(String sql, String catalog, String schema, int resultSetType, int resultSetConcurrency, int resultSetHoldability, PoolingConnection.StatementType statementType) {
        this.sql = sql;
        this.catalog = catalog;
        this.schema = schema;
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.resultSetHoldability = resultSetHoldability;
        this.statementType = statementType;
        this.autoGeneratedKeys = null;
        this.columnIndexes = null;
        this.columnNames = null;
        if (statementType == PoolingConnection.StatementType.PREPARED_STATEMENT) {
            this.builder = new PreparedStatementWithResultSetHoldability();
        } else if (statementType == PoolingConnection.StatementType.CALLABLE_STATEMENT) {
            this.builder = new PreparedCallWithResultSetHoldability();
        }
    }

    public PStmtKey(String sql, String catalog, String schema, int resultSetType, int resultSetConcurrency, PoolingConnection.StatementType statementType) {
        this.sql = sql;
        this.catalog = catalog;
        this.schema = schema;
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.resultSetHoldability = null;
        this.statementType = statementType;
        this.autoGeneratedKeys = null;
        this.columnIndexes = null;
        this.columnNames = null;
        if (statementType == PoolingConnection.StatementType.PREPARED_STATEMENT) {
            this.builder = new PreparedStatementWithResultSetConcurrency();
        } else if (statementType == PoolingConnection.StatementType.CALLABLE_STATEMENT) {
            this.builder = new PreparedCallWithResultSetConcurrency();
        }
    }

    public PStmtKey(String sql, String catalog, String schema, int[] columnIndexes) {
        this.sql = sql;
        this.catalog = catalog;
        this.schema = schema;
        this.statementType = PoolingConnection.StatementType.PREPARED_STATEMENT;
        this.autoGeneratedKeys = null;
        this.columnIndexes = columnIndexes == null ? null : Arrays.copyOf(columnIndexes, columnIndexes.length);
        this.columnNames = null;
        this.resultSetType = null;
        this.resultSetConcurrency = null;
        this.resultSetHoldability = null;
        this.builder = new PreparedStatementWithColumnIndexes();
    }

    public PStmtKey(String sql, String catalog, String schema, PoolingConnection.StatementType statementType) {
        this.sql = sql;
        this.catalog = catalog;
        this.schema = schema;
        this.statementType = statementType;
        this.autoGeneratedKeys = null;
        this.columnIndexes = null;
        this.columnNames = null;
        this.resultSetType = null;
        this.resultSetConcurrency = null;
        this.resultSetHoldability = null;
        if (statementType == PoolingConnection.StatementType.PREPARED_STATEMENT) {
            this.builder = new PreparedStatementSQL();
        } else if (statementType == PoolingConnection.StatementType.CALLABLE_STATEMENT) {
            this.builder = new PreparedCallSQL();
        }
    }

    public PStmtKey(String sql, String catalog, String schema, PoolingConnection.StatementType statementType, Integer autoGeneratedKeys) {
        this.sql = sql;
        this.catalog = catalog;
        this.schema = schema;
        this.statementType = statementType;
        this.autoGeneratedKeys = autoGeneratedKeys;
        this.columnIndexes = null;
        this.columnNames = null;
        this.resultSetType = null;
        this.resultSetConcurrency = null;
        this.resultSetHoldability = null;
        if (statementType == PoolingConnection.StatementType.PREPARED_STATEMENT) {
            this.builder = new PreparedStatementWithAutoGeneratedKeys();
        } else if (statementType == PoolingConnection.StatementType.CALLABLE_STATEMENT) {
            this.builder = new PreparedCallSQL();
        }
    }

    public PStmtKey(String sql, String catalog, String schema, String[] columnNames) {
        this.sql = sql;
        this.catalog = catalog;
        this.schema = schema;
        this.statementType = PoolingConnection.StatementType.PREPARED_STATEMENT;
        this.autoGeneratedKeys = null;
        this.columnIndexes = null;
        this.columnNames = columnNames == null ? null : Arrays.copyOf(columnNames, columnNames.length);
        this.resultSetType = null;
        this.resultSetConcurrency = null;
        this.resultSetHoldability = null;
        this.builder = new PreparedStatementWithColumnNames();
    }

    @Deprecated
    public PStmtKey(String sql, String catalog, String[] columnNames) {
        this.sql = sql;
        this.catalog = catalog;
        this.schema = null;
        this.statementType = PoolingConnection.StatementType.PREPARED_STATEMENT;
        this.autoGeneratedKeys = null;
        this.columnIndexes = null;
        this.columnNames = columnNames == null ? null : Arrays.copyOf(columnNames, columnNames.length);
        this.resultSetType = null;
        this.resultSetConcurrency = null;
        this.resultSetHoldability = null;
        this.builder = new PreparedStatementWithColumnNames();
    }

    public Statement createStatement(Connection connection) throws SQLException {
        if (this.builder == null) {
            throw new IllegalStateException("Prepared statement key is invalid.");
        }
        return this.builder.createStatement(connection);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PStmtKey other = (PStmtKey)obj;
        if (!Objects.equals(this.autoGeneratedKeys, other.autoGeneratedKeys)) {
            return false;
        }
        if (!Objects.equals(this.catalog, other.catalog)) {
            return false;
        }
        if (!Arrays.equals(this.columnIndexes, other.columnIndexes)) {
            return false;
        }
        if (!Arrays.equals(this.columnNames, other.columnNames)) {
            return false;
        }
        if (!Objects.equals(this.resultSetConcurrency, other.resultSetConcurrency)) {
            return false;
        }
        if (!Objects.equals(this.resultSetHoldability, other.resultSetHoldability)) {
            return false;
        }
        if (!Objects.equals(this.resultSetType, other.resultSetType)) {
            return false;
        }
        if (!Objects.equals(this.schema, other.schema)) {
            return false;
        }
        if (!Objects.equals(this.sql, other.sql)) {
            return false;
        }
        return this.statementType == other.statementType;
    }

    public Integer getAutoGeneratedKeys() {
        return this.autoGeneratedKeys;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public int[] getColumnIndexes() {
        return this.columnIndexes;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public Integer getResultSetConcurrency() {
        return this.resultSetConcurrency;
    }

    public Integer getResultSetHoldability() {
        return this.resultSetHoldability;
    }

    public Integer getResultSetType() {
        return this.resultSetType;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getSql() {
        return this.sql;
    }

    public PoolingConnection.StatementType getStmtType() {
        return this.statementType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.autoGeneratedKeys, this.catalog, Arrays.hashCode(this.columnIndexes), Arrays.hashCode(this.columnNames), this.resultSetConcurrency, this.resultSetHoldability, this.resultSetType, this.schema, this.sql, this.statementType});
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("PStmtKey: sql=");
        buf.append(this.sql);
        buf.append(", catalog=");
        buf.append(this.catalog);
        buf.append(", schema=");
        buf.append(this.schema);
        buf.append(", resultSetType=");
        buf.append(this.resultSetType);
        buf.append(", resultSetConcurrency=");
        buf.append(this.resultSetConcurrency);
        buf.append(", resultSetHoldability=");
        buf.append(this.resultSetHoldability);
        buf.append(", autoGeneratedKeys=");
        buf.append(this.autoGeneratedKeys);
        buf.append(", columnIndexes=");
        buf.append(Arrays.toString(this.columnIndexes));
        buf.append(", columnNames=");
        buf.append(Arrays.toString(this.columnNames));
        buf.append(", statementType=");
        buf.append((Object)this.statementType);
        return buf.toString();
    }

    private static interface StatementBuilder {
        public Statement createStatement(Connection var1) throws SQLException;
    }

    private class PreparedStatementWithResultSetHoldability
    implements StatementBuilder {
        private PreparedStatementWithResultSetHoldability() {
        }

        @Override
        public Statement createStatement(Connection connection) throws SQLException {
            return connection.prepareStatement(PStmtKey.this.sql, PStmtKey.this.resultSetType, PStmtKey.this.resultSetConcurrency, PStmtKey.this.resultSetHoldability);
        }
    }

    private class PreparedStatementWithResultSetConcurrency
    implements StatementBuilder {
        private PreparedStatementWithResultSetConcurrency() {
        }

        @Override
        public Statement createStatement(Connection connection) throws SQLException {
            return connection.prepareStatement(PStmtKey.this.sql, PStmtKey.this.resultSetType, PStmtKey.this.resultSetConcurrency);
        }
    }

    private class PreparedStatementWithColumnNames
    implements StatementBuilder {
        private PreparedStatementWithColumnNames() {
        }

        @Override
        public Statement createStatement(Connection connection) throws SQLException {
            return connection.prepareStatement(PStmtKey.this.sql, PStmtKey.this.columnNames);
        }
    }

    private class PreparedStatementWithColumnIndexes
    implements StatementBuilder {
        private PreparedStatementWithColumnIndexes() {
        }

        @Override
        public Statement createStatement(Connection connection) throws SQLException {
            return connection.prepareStatement(PStmtKey.this.sql, PStmtKey.this.columnIndexes);
        }
    }

    private class PreparedStatementWithAutoGeneratedKeys
    implements StatementBuilder {
        private PreparedStatementWithAutoGeneratedKeys() {
        }

        @Override
        public Statement createStatement(Connection connection) throws SQLException {
            return connection.prepareStatement(PStmtKey.this.sql, PStmtKey.this.autoGeneratedKeys);
        }
    }

    private class PreparedStatementSQL
    implements StatementBuilder {
        private PreparedStatementSQL() {
        }

        @Override
        public Statement createStatement(Connection connection) throws SQLException {
            return connection.prepareStatement(PStmtKey.this.sql);
        }
    }

    private class PreparedCallWithResultSetHoldability
    implements StatementBuilder {
        private PreparedCallWithResultSetHoldability() {
        }

        @Override
        public Statement createStatement(Connection connection) throws SQLException {
            return connection.prepareCall(PStmtKey.this.sql, PStmtKey.this.resultSetType, PStmtKey.this.resultSetConcurrency, PStmtKey.this.resultSetHoldability);
        }
    }

    private class PreparedCallWithResultSetConcurrency
    implements StatementBuilder {
        private PreparedCallWithResultSetConcurrency() {
        }

        @Override
        public Statement createStatement(Connection connection) throws SQLException {
            return connection.prepareCall(PStmtKey.this.sql, PStmtKey.this.resultSetType, PStmtKey.this.resultSetConcurrency);
        }
    }

    private class PreparedCallSQL
    implements StatementBuilder {
        private PreparedCallSQL() {
        }

        @Override
        public Statement createStatement(Connection connection) throws SQLException {
            return connection.prepareCall(PStmtKey.this.sql);
        }
    }
}

