/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.web.dbcp.dbcp2;

import com.tongweb.commons.logger.logging.Log;
import com.tongweb.commons.logger.logging.LogFactory;
import com.tongweb.web.dbcp.dbcp2.BasicDataSourceMXBean;
import com.tongweb.web.dbcp.dbcp2.ConnectionFactory;
import com.tongweb.web.dbcp.dbcp2.ConnectionFactoryFactory;
import com.tongweb.web.dbcp.dbcp2.DriverFactory;
import com.tongweb.web.dbcp.dbcp2.ObjectNameWrapper;
import com.tongweb.web.dbcp.dbcp2.PoolableConnection;
import com.tongweb.web.dbcp.dbcp2.PoolableConnectionFactory;
import com.tongweb.web.dbcp.dbcp2.PoolingDataSource;
import com.tongweb.web.dbcp.dbcp2.SwallowedExceptionLogger;
import com.tongweb.web.dbcp.dbcp2.Utils;
import com.tongweb.web.dbcp.pool2.PooledObject;
import com.tongweb.web.dbcp.pool2.impl.AbandonedConfig;
import com.tongweb.web.dbcp.pool2.impl.BaseObjectPoolConfig;
import com.tongweb.web.dbcp.pool2.impl.GenericObjectPool;
import com.tongweb.web.dbcp.pool2.impl.GenericObjectPoolConfig;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.sql.DataSource;

public class BasicDataSource
implements DataSource,
BasicDataSourceMXBean,
MBeanRegistration,
AutoCloseable {
    private static final Log log = LogFactory.getLog(BasicDataSource.class);
    private volatile Boolean defaultAutoCommit;
    private transient Boolean defaultReadOnly;
    private volatile int defaultTransactionIsolation = -1;
    private Integer defaultQueryTimeoutSeconds;
    private volatile String defaultCatalog;
    private volatile String defaultSchema;
    private boolean cacheState = true;
    private Driver driver;
    private String driverClassName;
    private ClassLoader driverClassLoader;
    private boolean lifo = true;
    private int maxTotal = 8;
    private int maxIdle = 8;
    private int minIdle = 0;
    private int initialSize = 0;
    private long maxWaitMillis = -1L;
    private boolean poolPreparedStatements = false;
    private boolean clearStatementPoolOnReturn = false;
    private int maxOpenPreparedStatements = -1;
    private boolean testOnCreate = false;
    private boolean testOnBorrow = true;
    private boolean testOnReturn = false;
    private long timeBetweenEvictionRunsMillis = -1L;
    private int numTestsPerEvictionRun = 3;
    private long minEvictableIdleTimeMillis = 1800000L;
    private long softMinEvictableIdleTimeMillis = -1L;
    private String evictionPolicyClassName = BaseObjectPoolConfig.DEFAULT_EVICTION_POLICY_CLASS_NAME;
    private boolean testWhileIdle = false;
    private volatile String password;
    private String url;
    private String userName;
    private volatile String validationQuery;
    private volatile int validationQueryTimeoutSeconds = -1;
    private String connectionFactoryClassName;
    private volatile List<String> connectionInitSqls;
    private boolean accessToUnderlyingConnectionAllowed = false;
    private long maxConnLifetimeMillis = -1L;
    private boolean logExpiredConnections = true;
    private String jmxName;
    private boolean autoCommitOnReturn = true;
    private boolean rollbackOnReturn = true;
    private volatile Set<String> disconnectionSqlCodes;
    private boolean fastFailValidation;
    private volatile GenericObjectPool<PoolableConnection> connectionPool;
    private Properties connectionProperties = new Properties();
    private volatile DataSource dataSource;
    private volatile PrintWriter logWriter = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, StandardCharsets.UTF_8));
    private AbandonedConfig abandonedConfig;
    private boolean closed;
    private ObjectNameWrapper registeredJmxObjectName;

    protected static void validateConnectionFactory(PoolableConnectionFactory connectionFactory) throws Exception {
        PoolableConnection conn = null;
        PooledObject<PoolableConnection> p = null;
        try {
            p = connectionFactory.makeObject();
            conn = p.getObject();
            connectionFactory.activateObject(p);
            connectionFactory.validateConnection(conn);
            connectionFactory.passivateObject(p);
        }
        finally {
            if (p != null) {
                connectionFactory.destroyObject(p);
            }
        }
    }

    public void addConnectionProperty(String name, String value) {
        this.connectionProperties.put(name, value);
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this.registeredJmxObjectName != null) {
            this.registeredJmxObjectName.unregisterMBean();
            this.registeredJmxObjectName = null;
        }
        this.closed = true;
        GenericObjectPool<PoolableConnection> oldPool = this.connectionPool;
        this.connectionPool = null;
        this.dataSource = null;
        try {
            if (oldPool != null) {
                oldPool.close();
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException(Utils.getMessage("pool.close.fail"), e);
        }
    }

    private void closeConnectionPool() {
        GenericObjectPool<PoolableConnection> oldPool = this.connectionPool;
        this.connectionPool = null;
        try {
            if (oldPool != null) {
                oldPool.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected ConnectionFactory createConnectionFactory() throws SQLException {
        return ConnectionFactoryFactory.createConnectionFactory(this, DriverFactory.createDriver(this));
    }

    protected void createConnectionPool(PoolableConnectionFactory factory) {
        GenericObjectPoolConfig<PoolableConnection> config = new GenericObjectPoolConfig<PoolableConnection>();
        this.updateJmxName(config);
        config.setJmxEnabled(this.registeredJmxObjectName != null);
        GenericObjectPool<PoolableConnection> gop = this.createObjectPool(factory, config, this.abandonedConfig);
        gop.setMaxTotal(this.maxTotal);
        gop.setMaxIdle(this.maxIdle);
        gop.setMinIdle(this.minIdle);
        gop.setMaxWaitMillis(this.maxWaitMillis);
        gop.setTestOnCreate(this.testOnCreate);
        gop.setTestOnBorrow(this.testOnBorrow);
        gop.setTestOnReturn(this.testOnReturn);
        gop.setNumTestsPerEvictionRun(this.numTestsPerEvictionRun);
        gop.setMinEvictableIdleTimeMillis(this.minEvictableIdleTimeMillis);
        gop.setSoftMinEvictableIdleTimeMillis(this.softMinEvictableIdleTimeMillis);
        gop.setTestWhileIdle(this.testWhileIdle);
        gop.setLifo(this.lifo);
        gop.setSwallowedExceptionListener(new SwallowedExceptionLogger(log, this.logExpiredConnections));
        gop.setEvictionPolicyClassName(this.evictionPolicyClassName);
        factory.setPool(gop);
        this.connectionPool = gop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataSource createDataSource() throws SQLException {
        if (this.closed) {
            throw new SQLException("Data source is closed");
        }
        if (this.dataSource != null) {
            return this.dataSource;
        }
        BasicDataSource basicDataSource = this;
        synchronized (basicDataSource) {
            DataSource newDataSource;
            PoolableConnectionFactory poolableConnectionFactory;
            if (this.dataSource != null) {
                return this.dataSource;
            }
            this.jmxRegister();
            ConnectionFactory driverConnectionFactory = this.createConnectionFactory();
            boolean success = false;
            try {
                poolableConnectionFactory = this.createPoolableConnectionFactory(driverConnectionFactory);
                poolableConnectionFactory.setPoolStatements(this.poolPreparedStatements);
                poolableConnectionFactory.setMaxOpenPreparedStatements(this.maxOpenPreparedStatements);
                success = true;
            }
            catch (RuntimeException | SQLException se) {
                throw se;
            }
            catch (Exception ex) {
                throw new SQLException("Error creating connection factory", ex);
            }
            if (success) {
                this.createConnectionPool(poolableConnectionFactory);
            }
            success = false;
            try {
                newDataSource = this.createDataSourceInstance();
                newDataSource.setLogWriter(this.logWriter);
                success = true;
            }
            catch (RuntimeException | SQLException se) {
                throw se;
            }
            catch (Exception ex) {
                throw new SQLException("Error creating datasource", ex);
            }
            finally {
                if (!success) {
                    this.closeConnectionPool();
                }
            }
            try {
                for (int i = 0; i < this.initialSize; ++i) {
                    this.connectionPool.addObject();
                }
            }
            catch (Exception e) {
                this.closeConnectionPool();
                throw new SQLException("Error preloading the connection pool", e);
            }
            this.startPoolMaintenance();
            this.dataSource = newDataSource;
            return this.dataSource;
        }
    }

    protected DataSource createDataSourceInstance() throws SQLException {
        PoolingDataSource<PoolableConnection> pds = new PoolingDataSource<PoolableConnection>(this.connectionPool);
        pds.setAccessToUnderlyingConnectionAllowed(this.isAccessToUnderlyingConnectionAllowed());
        return pds;
    }

    protected GenericObjectPool<PoolableConnection> createObjectPool(PoolableConnectionFactory factory, GenericObjectPoolConfig<PoolableConnection> poolConfig, AbandonedConfig abandonedConfig) {
        GenericObjectPool<PoolableConnection> gop = abandonedConfig != null && (abandonedConfig.getRemoveAbandonedOnBorrow() || abandonedConfig.getRemoveAbandonedOnMaintenance()) ? new GenericObjectPool<PoolableConnection>(factory, poolConfig, abandonedConfig) : new GenericObjectPool<PoolableConnection>(factory, poolConfig, abandonedConfig);
        return gop;
    }

    protected PoolableConnectionFactory createPoolableConnectionFactory(ConnectionFactory driverConnectionFactory) throws SQLException {
        PoolableConnectionFactory connectionFactory = null;
        try {
            connectionFactory = new PoolableConnectionFactory(driverConnectionFactory, ObjectNameWrapper.unwrap(this.registeredJmxObjectName));
            connectionFactory.setValidationQuery(this.validationQuery);
            connectionFactory.setValidationQueryTimeout(this.validationQueryTimeoutSeconds);
            connectionFactory.setConnectionInitSql(this.connectionInitSqls);
            connectionFactory.setDefaultReadOnly(this.defaultReadOnly);
            connectionFactory.setDefaultAutoCommit(this.defaultAutoCommit);
            connectionFactory.setDefaultTransactionIsolation(this.defaultTransactionIsolation);
            connectionFactory.setDefaultCatalog(this.defaultCatalog);
            connectionFactory.setDefaultSchema(this.defaultSchema);
            connectionFactory.setCacheState(this.cacheState);
            connectionFactory.setPoolStatements(this.poolPreparedStatements);
            connectionFactory.setClearStatementPoolOnReturn(this.clearStatementPoolOnReturn);
            connectionFactory.setMaxOpenPreparedStatements(this.maxOpenPreparedStatements);
            connectionFactory.setMaxConnLifetimeMillis(this.maxConnLifetimeMillis);
            connectionFactory.setRollbackOnReturn(this.getRollbackOnReturn());
            connectionFactory.setAutoCommitOnReturn(this.getAutoCommitOnReturn());
            connectionFactory.setDefaultQueryTimeout(this.getDefaultQueryTimeout());
            connectionFactory.setFastFailValidation(this.fastFailValidation);
            connectionFactory.setDisconnectionSqlCodes(this.disconnectionSqlCodes);
            BasicDataSource.validateConnectionFactory(connectionFactory);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Cannot create PoolableConnectionFactory (" + e.getMessage() + ")", e);
        }
        return connectionFactory;
    }

    public void evict() throws Exception {
        if (this.connectionPool != null) {
            this.connectionPool.evict();
        }
    }

    public PrintWriter getAbandonedLogWriter() {
        return this.abandonedConfig == null ? null : this.abandonedConfig.getLogWriter();
    }

    @Override
    public boolean getAbandonedUsageTracking() {
        return this.abandonedConfig != null && this.abandonedConfig.getUseUsageTracking();
    }

    public boolean getAutoCommitOnReturn() {
        return this.autoCommitOnReturn;
    }

    @Override
    public boolean getCacheState() {
        return this.cacheState;
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (Utils.IS_SECURITY_ENABLED) {
            PrivilegedExceptionAction<Connection> action = () -> this.createDataSource().getConnection();
            try {
                return AccessController.doPrivileged(action);
            }
            catch (PrivilegedActionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof SQLException) {
                    throw (SQLException)cause;
                }
                throw new SQLException(e);
            }
        }
        return this.createDataSource().getConnection();
    }

    @Override
    public Connection getConnection(String user, String pass) throws SQLException {
        throw new UnsupportedOperationException("Not supported by BasicDataSource");
    }

    public String getConnectionFactoryClassName() {
        return this.connectionFactoryClassName;
    }

    public List<String> getConnectionInitSqls() {
        List<String> result = this.connectionInitSqls;
        return result == null ? Collections.emptyList() : result;
    }

    @Override
    public String[] getConnectionInitSqlsAsArray() {
        return this.getConnectionInitSqls().toArray(Utils.EMPTY_STRING_ARRAY);
    }

    protected GenericObjectPool<PoolableConnection> getConnectionPool() {
        return this.connectionPool;
    }

    Properties getConnectionProperties() {
        return this.connectionProperties;
    }

    @Override
    public Boolean getDefaultAutoCommit() {
        return this.defaultAutoCommit;
    }

    @Override
    public String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    public Integer getDefaultQueryTimeout() {
        return this.defaultQueryTimeoutSeconds;
    }

    @Override
    public Boolean getDefaultReadOnly() {
        return this.defaultReadOnly;
    }

    @Override
    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    @Override
    public int getDefaultTransactionIsolation() {
        return this.defaultTransactionIsolation;
    }

    public Set<String> getDisconnectionSqlCodes() {
        Set<String> result = this.disconnectionSqlCodes;
        return result == null ? Collections.emptySet() : result;
    }

    @Override
    public String[] getDisconnectionSqlCodesAsArray() {
        return this.getDisconnectionSqlCodes().toArray(Utils.EMPTY_STRING_ARRAY);
    }

    public synchronized Driver getDriver() {
        return this.driver;
    }

    public synchronized ClassLoader getDriverClassLoader() {
        return this.driverClassLoader;
    }

    @Override
    public synchronized String getDriverClassName() {
        return this.driverClassName;
    }

    @Deprecated
    public boolean getEnableAutoCommitOnReturn() {
        return this.autoCommitOnReturn;
    }

    public synchronized String getEvictionPolicyClassName() {
        return this.evictionPolicyClassName;
    }

    @Override
    public boolean getFastFailValidation() {
        return this.fastFailValidation;
    }

    @Override
    public synchronized int getInitialSize() {
        return this.initialSize;
    }

    public String getJmxName() {
        return this.jmxName;
    }

    @Override
    public synchronized boolean getLifo() {
        return this.lifo;
    }

    @Override
    public boolean getLogAbandoned() {
        return this.abandonedConfig != null && this.abandonedConfig.getLogAbandoned();
    }

    @Override
    public boolean getLogExpiredConnections() {
        return this.logExpiredConnections;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        throw new UnsupportedOperationException("Not supported by BasicDataSource");
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.createDataSource().getLogWriter();
    }

    @Override
    public long getMaxConnLifetimeMillis() {
        return this.maxConnLifetimeMillis;
    }

    @Override
    public synchronized int getMaxIdle() {
        return this.maxIdle;
    }

    @Override
    public synchronized int getMaxOpenPreparedStatements() {
        return this.maxOpenPreparedStatements;
    }

    @Override
    public synchronized int getMaxTotal() {
        return this.maxTotal;
    }

    @Override
    public synchronized long getMaxWaitMillis() {
        return this.maxWaitMillis;
    }

    @Override
    public synchronized long getMinEvictableIdleTimeMillis() {
        return this.minEvictableIdleTimeMillis;
    }

    @Override
    public synchronized int getMinIdle() {
        return this.minIdle;
    }

    @Override
    public int getNumActive() {
        GenericObjectPool<PoolableConnection> pool = this.connectionPool;
        return pool == null ? 0 : pool.getNumActive();
    }

    @Override
    public int getNumIdle() {
        GenericObjectPool<PoolableConnection> pool = this.connectionPool;
        return pool == null ? 0 : pool.getNumIdle();
    }

    @Override
    public synchronized int getNumTestsPerEvictionRun() {
        return this.numTestsPerEvictionRun;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    protected ObjectName getRegisteredJmxName() {
        return ObjectNameWrapper.unwrap(this.registeredJmxObjectName);
    }

    @Override
    public boolean getRemoveAbandonedOnBorrow() {
        return this.abandonedConfig != null && this.abandonedConfig.getRemoveAbandonedOnBorrow();
    }

    @Override
    public boolean getRemoveAbandonedOnMaintenance() {
        return this.abandonedConfig != null && this.abandonedConfig.getRemoveAbandonedOnMaintenance();
    }

    @Override
    public int getRemoveAbandonedTimeout() {
        return this.abandonedConfig == null ? 300 : this.abandonedConfig.getRemoveAbandonedTimeout();
    }

    public boolean getRollbackOnReturn() {
        return this.rollbackOnReturn;
    }

    @Override
    public synchronized long getSoftMinEvictableIdleTimeMillis() {
        return this.softMinEvictableIdleTimeMillis;
    }

    @Override
    public synchronized boolean getTestOnBorrow() {
        return this.testOnBorrow;
    }

    @Override
    public synchronized boolean getTestOnCreate() {
        return this.testOnCreate;
    }

    public synchronized boolean getTestOnReturn() {
        return this.testOnReturn;
    }

    @Override
    public synchronized boolean getTestWhileIdle() {
        return this.testWhileIdle;
    }

    @Override
    public synchronized long getTimeBetweenEvictionRunsMillis() {
        return this.timeBetweenEvictionRunsMillis;
    }

    @Override
    public synchronized String getUrl() {
        return this.url;
    }

    @Override
    public String getUsername() {
        return this.userName;
    }

    @Override
    public String getValidationQuery() {
        return this.validationQuery;
    }

    @Override
    public int getValidationQueryTimeout() {
        return this.validationQueryTimeoutSeconds;
    }

    public void invalidateConnection(Connection connection) throws IllegalStateException {
        PoolableConnection poolableConnection;
        if (connection == null) {
            return;
        }
        if (this.connectionPool == null) {
            throw new IllegalStateException("Cannot invalidate connection: ConnectionPool is null.");
        }
        try {
            poolableConnection = connection.unwrap(PoolableConnection.class);
            if (poolableConnection == null) {
                throw new IllegalStateException("Cannot invalidate connection: Connection is not a poolable connection.");
            }
        }
        catch (SQLException e) {
            throw new IllegalStateException("Cannot invalidate connection: Unwrapping poolable connection failed.", e);
        }
        try {
            this.connectionPool.invalidateObject(poolableConnection);
        }
        catch (Exception e) {
            throw new IllegalStateException("Invalidating connection threw unexpected exception", e);
        }
    }

    @Override
    public synchronized boolean isAccessToUnderlyingConnectionAllowed() {
        return this.accessToUnderlyingConnectionAllowed;
    }

    @Override
    public boolean isClearStatementPoolOnReturn() {
        return this.clearStatementPoolOnReturn;
    }

    @Override
    public synchronized boolean isClosed() {
        return this.closed;
    }

    private boolean isEmpty(String value) {
        return value == null || value.trim().isEmpty();
    }

    @Override
    public synchronized boolean isPoolPreparedStatements() {
        return this.poolPreparedStatements;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    private void jmxRegister() {
        if (this.registeredJmxObjectName != null) {
            return;
        }
        String requestedName = this.getJmxName();
        if (requestedName == null) {
            return;
        }
        try {
            ObjectNameWrapper.wrap(requestedName).registerMBean(this);
        }
        catch (MalformedObjectNameException e) {
            log.warn((Object)("The requested JMX name [" + requestedName + "] was not valid and will be ignored."));
        }
    }

    protected void log(String message) {
        if (this.logWriter != null) {
            this.logWriter.println(message);
        }
    }

    protected void log(String message, Throwable throwable) {
        if (this.logWriter != null) {
            this.logWriter.println(message);
            throwable.printStackTrace(this.logWriter);
        }
    }

    @Override
    public void postDeregister() {
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName objectName) {
        String requestedName = this.getJmxName();
        if (requestedName != null) {
            try {
                this.registeredJmxObjectName = ObjectNameWrapper.wrap(requestedName);
            }
            catch (MalformedObjectNameException e) {
                log.warn((Object)("The requested JMX name [" + requestedName + "] was not valid and will be ignored."));
            }
        }
        if (this.registeredJmxObjectName == null) {
            this.registeredJmxObjectName = ObjectNameWrapper.wrap(objectName);
        }
        return ObjectNameWrapper.unwrap(this.registeredJmxObjectName);
    }

    public void removeConnectionProperty(String name) {
        this.connectionProperties.remove(name);
    }

    @Override
    public synchronized void restart() throws SQLException {
        this.close();
        this.start();
    }

    public void setAbandonedLogWriter(PrintWriter logWriter) {
        if (this.abandonedConfig == null) {
            this.abandonedConfig = new AbandonedConfig();
        }
        this.abandonedConfig.setLogWriter(logWriter);
        GenericObjectPool<PoolableConnection> gop = this.connectionPool;
        if (gop != null) {
            gop.setAbandonedConfig(this.abandonedConfig);
        }
    }

    public void setAbandonedUsageTracking(boolean usageTracking) {
        if (this.abandonedConfig == null) {
            this.abandonedConfig = new AbandonedConfig();
        }
        this.abandonedConfig.setUseUsageTracking(usageTracking);
        GenericObjectPool<PoolableConnection> gop = this.connectionPool;
        if (gop != null) {
            gop.setAbandonedConfig(this.abandonedConfig);
        }
    }

    public synchronized void setAccessToUnderlyingConnectionAllowed(boolean allow) {
        this.accessToUnderlyingConnectionAllowed = allow;
    }

    public void setAutoCommitOnReturn(boolean autoCommitOnReturn) {
        this.autoCommitOnReturn = autoCommitOnReturn;
    }

    public void setCacheState(boolean cacheState) {
        this.cacheState = cacheState;
    }

    public void setClearStatementPoolOnReturn(boolean clearStatementPoolOnReturn) {
        this.clearStatementPoolOnReturn = clearStatementPoolOnReturn;
    }

    public void setConnectionFactoryClassName(String connectionFactoryClassName) {
        this.connectionFactoryClassName = this.isEmpty(connectionFactoryClassName) ? null : connectionFactoryClassName;
    }

    public void setConnectionInitSqls(Collection<String> connectionInitSqls) {
        if (connectionInitSqls != null && connectionInitSqls.size() > 0) {
            ArrayList<String> newVal = null;
            for (String s : connectionInitSqls) {
                if (this.isEmpty(s)) continue;
                if (newVal == null) {
                    newVal = new ArrayList<String>();
                }
                newVal.add(s);
            }
            this.connectionInitSqls = newVal;
        } else {
            this.connectionInitSqls = null;
        }
    }

    public void setConnectionProperties(String connectionProperties) {
        Objects.requireNonNull(connectionProperties, "connectionProperties is null");
        String[] entries = connectionProperties.split(";");
        Properties properties = new Properties();
        for (String entry : entries) {
            if (entry.length() <= 0) continue;
            int index = entry.indexOf(61);
            if (index > 0) {
                String name = entry.substring(0, index);
                String value = entry.substring(index + 1);
                properties.setProperty(name, value);
                continue;
            }
            properties.setProperty(entry, "");
        }
        this.connectionProperties = properties;
    }

    public void setDefaultAutoCommit(Boolean defaultAutoCommit) {
        this.defaultAutoCommit = defaultAutoCommit;
    }

    public void setDefaultCatalog(String defaultCatalog) {
        this.defaultCatalog = this.isEmpty(defaultCatalog) ? null : defaultCatalog;
    }

    public void setDefaultQueryTimeout(Integer defaultQueryTimeoutSeconds) {
        this.defaultQueryTimeoutSeconds = defaultQueryTimeoutSeconds;
    }

    public void setDefaultReadOnly(Boolean defaultReadOnly) {
        this.defaultReadOnly = defaultReadOnly;
    }

    public void setDefaultSchema(String defaultSchema) {
        this.defaultSchema = this.isEmpty(defaultSchema) ? null : defaultSchema;
    }

    public void setDefaultTransactionIsolation(int defaultTransactionIsolation) {
        this.defaultTransactionIsolation = defaultTransactionIsolation;
    }

    public void setDisconnectionSqlCodes(Collection<String> disconnectionSqlCodes) {
        if (disconnectionSqlCodes != null && disconnectionSqlCodes.size() > 0) {
            HashSet<String> newVal = null;
            for (String s : disconnectionSqlCodes) {
                if (this.isEmpty(s)) continue;
                if (newVal == null) {
                    newVal = new HashSet<String>();
                }
                newVal.add(s);
            }
            this.disconnectionSqlCodes = newVal;
        } else {
            this.disconnectionSqlCodes = null;
        }
    }

    public synchronized void setDriver(Driver driver) {
        this.driver = driver;
    }

    public synchronized void setDriverClassLoader(ClassLoader driverClassLoader) {
        this.driverClassLoader = driverClassLoader;
    }

    public synchronized void setDriverClassName(String driverClassName) {
        this.driverClassName = this.isEmpty(driverClassName) ? null : driverClassName;
    }

    @Deprecated
    public void setEnableAutoCommitOnReturn(boolean autoCommitOnReturn) {
        this.autoCommitOnReturn = autoCommitOnReturn;
    }

    public synchronized void setEvictionPolicyClassName(String evictionPolicyClassName) {
        if (this.connectionPool != null) {
            this.connectionPool.setEvictionPolicyClassName(evictionPolicyClassName);
        }
        this.evictionPolicyClassName = evictionPolicyClassName;
    }

    public void setFastFailValidation(boolean fastFailValidation) {
        this.fastFailValidation = fastFailValidation;
    }

    public synchronized void setInitialSize(int initialSize) {
        this.initialSize = initialSize;
    }

    public void setJmxName(String jmxName) {
        this.jmxName = jmxName;
    }

    public synchronized void setLifo(boolean lifo) {
        this.lifo = lifo;
        if (this.connectionPool != null) {
            this.connectionPool.setLifo(lifo);
        }
    }

    public void setLogAbandoned(boolean logAbandoned) {
        if (this.abandonedConfig == null) {
            this.abandonedConfig = new AbandonedConfig();
        }
        this.abandonedConfig.setLogAbandoned(logAbandoned);
        GenericObjectPool<PoolableConnection> gop = this.connectionPool;
        if (gop != null) {
            gop.setAbandonedConfig(this.abandonedConfig);
        }
    }

    public void setLogExpiredConnections(boolean logExpiredConnections) {
        this.logExpiredConnections = logExpiredConnections;
    }

    @Override
    public void setLoginTimeout(int loginTimeout) throws SQLException {
        throw new UnsupportedOperationException("Not supported by BasicDataSource");
    }

    @Override
    public void setLogWriter(PrintWriter logWriter) throws SQLException {
        this.createDataSource().setLogWriter(logWriter);
        this.logWriter = logWriter;
    }

    public void setMaxConnLifetimeMillis(long maxConnLifetimeMillis) {
        this.maxConnLifetimeMillis = maxConnLifetimeMillis;
    }

    public synchronized void setMaxIdle(int maxIdle) {
        this.maxIdle = maxIdle;
        if (this.connectionPool != null) {
            this.connectionPool.setMaxIdle(maxIdle);
        }
    }

    public synchronized void setMaxOpenPreparedStatements(int maxOpenStatements) {
        this.maxOpenPreparedStatements = maxOpenStatements;
    }

    public synchronized void setMaxTotal(int maxTotal) {
        this.maxTotal = maxTotal;
        if (this.connectionPool != null) {
            this.connectionPool.setMaxTotal(maxTotal);
        }
    }

    public synchronized void setMaxWaitMillis(long maxWaitMillis) {
        this.maxWaitMillis = maxWaitMillis;
        if (this.connectionPool != null) {
            this.connectionPool.setMaxWaitMillis(maxWaitMillis);
        }
    }

    public synchronized void setMinEvictableIdleTimeMillis(long minEvictableIdleTimeMillis) {
        this.minEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
        if (this.connectionPool != null) {
            this.connectionPool.setMinEvictableIdleTimeMillis(minEvictableIdleTimeMillis);
        }
    }

    public synchronized void setMinIdle(int minIdle) {
        this.minIdle = minIdle;
        if (this.connectionPool != null) {
            this.connectionPool.setMinIdle(minIdle);
        }
    }

    public synchronized void setNumTestsPerEvictionRun(int numTestsPerEvictionRun) {
        this.numTestsPerEvictionRun = numTestsPerEvictionRun;
        if (this.connectionPool != null) {
            this.connectionPool.setNumTestsPerEvictionRun(numTestsPerEvictionRun);
        }
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public synchronized void setPoolPreparedStatements(boolean poolingStatements) {
        this.poolPreparedStatements = poolingStatements;
    }

    public void setRemoveAbandonedOnBorrow(boolean removeAbandonedOnBorrow) {
        if (this.abandonedConfig == null) {
            this.abandonedConfig = new AbandonedConfig();
        }
        this.abandonedConfig.setRemoveAbandonedOnBorrow(removeAbandonedOnBorrow);
        GenericObjectPool<PoolableConnection> gop = this.connectionPool;
        if (gop != null) {
            gop.setAbandonedConfig(this.abandonedConfig);
        }
    }

    public void setRemoveAbandonedOnMaintenance(boolean removeAbandonedOnMaintenance) {
        if (this.abandonedConfig == null) {
            this.abandonedConfig = new AbandonedConfig();
        }
        this.abandonedConfig.setRemoveAbandonedOnMaintenance(removeAbandonedOnMaintenance);
        GenericObjectPool<PoolableConnection> gop = this.connectionPool;
        if (gop != null) {
            gop.setAbandonedConfig(this.abandonedConfig);
        }
    }

    public void setRemoveAbandonedTimeout(int removeAbandonedTimeout) {
        if (this.abandonedConfig == null) {
            this.abandonedConfig = new AbandonedConfig();
        }
        this.abandonedConfig.setRemoveAbandonedTimeout(removeAbandonedTimeout);
        GenericObjectPool<PoolableConnection> gop = this.connectionPool;
        if (gop != null) {
            gop.setAbandonedConfig(this.abandonedConfig);
        }
    }

    public void setRollbackOnReturn(boolean rollbackOnReturn) {
        this.rollbackOnReturn = rollbackOnReturn;
    }

    public synchronized void setSoftMinEvictableIdleTimeMillis(long softMinEvictableIdleTimeMillis) {
        this.softMinEvictableIdleTimeMillis = softMinEvictableIdleTimeMillis;
        if (this.connectionPool != null) {
            this.connectionPool.setSoftMinEvictableIdleTimeMillis(softMinEvictableIdleTimeMillis);
        }
    }

    public synchronized void setTestOnBorrow(boolean testOnBorrow) {
        this.testOnBorrow = testOnBorrow;
        if (this.connectionPool != null) {
            this.connectionPool.setTestOnBorrow(testOnBorrow);
        }
    }

    public synchronized void setTestOnCreate(boolean testOnCreate) {
        this.testOnCreate = testOnCreate;
        if (this.connectionPool != null) {
            this.connectionPool.setTestOnCreate(testOnCreate);
        }
    }

    public synchronized void setTestOnReturn(boolean testOnReturn) {
        this.testOnReturn = testOnReturn;
        if (this.connectionPool != null) {
            this.connectionPool.setTestOnReturn(testOnReturn);
        }
    }

    public synchronized void setTestWhileIdle(boolean testWhileIdle) {
        this.testWhileIdle = testWhileIdle;
        if (this.connectionPool != null) {
            this.connectionPool.setTestWhileIdle(testWhileIdle);
        }
    }

    public synchronized void setTimeBetweenEvictionRunsMillis(long timeBetweenEvictionRunsMillis) {
        this.timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
        if (this.connectionPool != null) {
            this.connectionPool.setTimeBetweenEvictionRunsMillis(timeBetweenEvictionRunsMillis);
        }
    }

    public synchronized void setUrl(String url) {
        this.url = url;
    }

    public void setUsername(String userName) {
        this.userName = userName;
    }

    public void setValidationQuery(String validationQuery) {
        this.validationQuery = this.isEmpty(validationQuery) ? null : validationQuery;
    }

    public void setValidationQueryTimeout(int validationQueryTimeoutSeconds) {
        this.validationQueryTimeoutSeconds = validationQueryTimeoutSeconds;
    }

    @Override
    public synchronized void start() throws SQLException {
        this.closed = false;
        this.createDataSource();
    }

    protected void startPoolMaintenance() {
        if (this.connectionPool != null && this.timeBetweenEvictionRunsMillis > 0L) {
            this.connectionPool.setTimeBetweenEvictionRunsMillis(this.timeBetweenEvictionRunsMillis);
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException("BasicDataSource is not a wrapper.");
    }

    private void updateJmxName(GenericObjectPoolConfig<?> config) {
        if (this.registeredJmxObjectName == null) {
            return;
        }
        StringBuilder base = new StringBuilder(this.registeredJmxObjectName.toString());
        base.append(",connectionpool=");
        config.setJmxNameBase(base.toString());
        config.setJmxNamePrefix("connections");
    }

    static {
        DriverManager.getDrivers();
        try {
            if (Utils.IS_SECURITY_ENABLED) {
                ClassLoader loader = BasicDataSource.class.getClassLoader();
                String dbcpPackageName = BasicDataSource.class.getPackage().getName();
                loader.loadClass(dbcpPackageName + ".DelegatingCallableStatement");
                loader.loadClass(dbcpPackageName + ".DelegatingDatabaseMetaData");
                loader.loadClass(dbcpPackageName + ".DelegatingPreparedStatement");
                loader.loadClass(dbcpPackageName + ".DelegatingResultSet");
                loader.loadClass(dbcpPackageName + ".PoolableCallableStatement");
                loader.loadClass(dbcpPackageName + ".PoolablePreparedStatement");
                loader.loadClass(dbcpPackageName + ".PoolingConnection$StatementType");
                loader.loadClass(dbcpPackageName + ".PStmtKey");
                String poolPackageName = PooledObject.class.getPackage().getName();
                loader.loadClass(poolPackageName + ".impl.LinkedBlockingDeque$Node");
                loader.loadClass(poolPackageName + ".impl.GenericKeyedObjectPool$ObjectDeque");
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalStateException("Unable to pre-load classes", cnfe);
        }
    }
}

