/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.web.buildutil.translate;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;

public class Utils {
    private static final Pattern ADD_CONTINUATION = Pattern.compile("\\n", 8);
    private static final Pattern ESCAPE_LEADING_SPACE = Pattern.compile("^(\\s)", 8);
    private static final Pattern FIX_SINGLE_QUOTE = Pattern.compile("(?<!')'(?!')", 8);

    private Utils() {
    }

    static String getLanguage(String name) {
        return name.substring("LocalStrings".length(), name.length() - ".properties".length());
    }

    static Properties load(File f) {
        Properties props = new Properties();
        try (FileInputStream fis = new FileInputStream(f);
             InputStreamReader r = new InputStreamReader((InputStream)fis, StandardCharsets.UTF_8);){
            props.load(r);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return props;
    }

    static String formatValue(String in) {
        String result = ADD_CONTINUATION.matcher(in).replaceAll("\\\\n\\\\\n");
        if (result.endsWith("\\\n")) {
            result = result.substring(0, result.length() - 2);
        }
        if ((result = ESCAPE_LEADING_SPACE.matcher(result).replaceAll("\\\\$1")).contains("\n\\\t")) {
            result = result.replace("\n\\\t", "\n\\t");
        }
        if (result.contains("[{0}]")) {
            result = FIX_SINGLE_QUOTE.matcher(result).replaceAll("''");
        }
        return result.trim();
    }

    static void processDirectory(File root, File dir, Map<String, Properties> translations) throws IOException {
        File[] files = dir.listFiles();
        if (files == null) {
            throw new IllegalArgumentException("Not a directory [" + dir.getAbsolutePath() + "]");
        }
        for (File f : files) {
            if (f.isDirectory()) {
                Utils.processDirectory(root, f, translations);
                continue;
            }
            if (!f.isFile()) continue;
            Utils.processFile(root, f, translations);
        }
    }

    static void processFile(File root, File f, Map<String, Properties> translations) throws IOException {
        String name = f.getName();
        if (!name.startsWith("LocalStrings")) {
            return;
        }
        String language = Utils.getLanguage(name);
        String keyPrefix = Utils.getKeyPrefix(root, f);
        Properties props = Utils.load(f);
        Properties translation = translations.get(language);
        if (translation == null) {
            translation = new Properties();
            translations.put(language, translation);
        }
        for (Object obj : props.keySet()) {
            String key = (String)obj;
            String value = props.getProperty(key);
            translation.put(keyPrefix + key, value);
        }
    }

    static String getKeyPrefix(File root, File f) throws IOException {
        String prefix = f.getParentFile().getCanonicalPath();
        prefix = prefix.substring(root.getCanonicalPath().length() + 1);
        prefix = prefix.replace(File.separatorChar, '.');
        prefix = prefix + ".zzz.";
        return prefix;
    }

    static void export(String language, Properties translation, File storageDir) {
        File out = new File(storageDir, "LocalStrings" + language + ".properties");
        try (FileOutputStream fos = new FileOutputStream(out);
             OutputStreamWriter w = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8);){
            Object[] keys = translation.keySet().toArray(new String[0]);
            Arrays.sort(keys);
            for (Object key : keys) {
                w.write(key + "=" + Utils.formatValue(translation.getProperty((String)key)) + "\n");
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
}

