/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.web.buildutil.translate;

import com.tongweb.web.buildutil.translate.Utils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Properties;

public class Import {
    public static void main(String ... args) throws IOException {
        File root = new File(".settings/translations");
        for (File f : root.listFiles()) {
            if (!f.isFile() || !f.getName().startsWith("LocalStrings")) continue;
            Import.processFile(f);
        }
    }

    private static void processFile(File f) throws IOException {
        String language = Utils.getLanguage(f.getName());
        Properties props = Utils.load(f);
        Object[] objKeys = props.keySet().toArray();
        Arrays.sort(objKeys);
        String currentPkg = null;
        Writer w = null;
        String currentGroup = "zzz";
        for (Object objKey : objKeys) {
            String key = (String)objKey;
            String value = props.getProperty(key);
            if (value.trim().length() == 0) continue;
            CompositeKey cKey = new CompositeKey(key);
            if (!cKey.pkg.equals(currentPkg)) {
                currentPkg = cKey.pkg;
                if (w != null) {
                    w.close();
                }
                File outFile = new File(currentPkg.replace('.', File.separatorChar), "LocalStrings" + language + ".properties");
                FileOutputStream fos = new FileOutputStream(outFile);
                w = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8);
                com.tongweb.web.buildutil.Utils.insertLicense(w);
            }
            if (!currentGroup.equals(cKey.group)) {
                currentGroup = cKey.group;
                w.write(System.lineSeparator());
            }
            w.write(cKey.key + "=" + Utils.formatValue(value));
            w.write(System.lineSeparator());
        }
        if (w != null) {
            w.close();
        }
    }

    private static class CompositeKey {
        public final String pkg;
        public final String key;
        public final String group;

        public CompositeKey(String in) {
            int posPkg = in.indexOf(".zzz.");
            this.pkg = in.substring(0, posPkg);
            this.key = in.substring(posPkg + ".zzz.".length());
            int posGroup = this.key.indexOf(46);
            this.group = posGroup == -1 ? "" : this.key.substring(0, posGroup);
        }
    }
}

