/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.web.buildutil.translate;

import com.tongweb.web.buildutil.translate.Constants;
import com.tongweb.web.buildutil.translate.Utils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public abstract class BackportBase {
    protected final Map<String, Properties> sourceTranslations = new HashMap<String, Properties>();
    protected final Map<String, Properties> targetTranslations = new HashMap<String, Properties>();
    protected final File targetRoot;
    protected final Properties sourceEnglish;
    protected final Properties targetEnglish;
    protected final File storageDir;

    protected BackportBase(String ... args) throws IOException {
        File directory;
        if (args.length != 1) {
            throw new IllegalArgumentException("Missing back-port target");
        }
        this.targetRoot = new File(args[0]);
        if (!this.targetRoot.isDirectory()) {
            throw new IllegalArgumentException("Back-port target not a directory");
        }
        File sourceRoot = new File(".");
        for (String dir : Constants.SEARCH_DIRS) {
            directory = new File(dir);
            Utils.processDirectory(sourceRoot, directory, this.sourceTranslations);
        }
        for (String dir : Constants.SEARCH_DIRS) {
            directory = new File(this.targetRoot, dir);
            Utils.processDirectory(this.targetRoot, directory, this.targetTranslations);
        }
        this.sourceEnglish = this.sourceTranslations.get("");
        this.targetEnglish = this.targetTranslations.get("");
        this.storageDir = new File(this.targetRoot, ".settings/translations");
    }

    protected abstract void execute() throws IOException;
}

