/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.web.buildutil;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class Txt2Html
extends Task {
    private File todir;
    private final List<FileSet> filesets = new LinkedList<FileSet>();
    private static final String SOURCE_ENCODING = "ISO-8859-1";
    private static final String LINE_SEPARATOR = "\r\n";

    public void setTodir(File todir) {
        this.todir = todir;
    }

    public void addFileset(FileSet fs) {
        this.filesets.add(fs);
    }

    public void execute() throws BuildException {
        int count = 0;
        for (FileSet fs : this.filesets) {
            String[] files;
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            File basedir = ds.getBasedir();
            for (String file : files = ds.getIncludedFiles()) {
                File from = new File(basedir, file);
                File to = new File(this.todir, file + ".html");
                if (to.exists() && from.lastModified() <= to.lastModified()) continue;
                this.log("Converting file '" + from.getAbsolutePath() + "' to '" + to.getAbsolutePath(), 3);
                try {
                    this.convert(from, to);
                }
                catch (IOException e) {
                    throw new BuildException("Could not convert '" + from.getAbsolutePath() + "' to '" + to.getAbsolutePath() + "'", (Throwable)e);
                }
                ++count;
            }
            if (count <= 0) continue;
            this.log("Converted " + count + " file" + (count > 1 ? "s" : "") + " to " + this.todir.getAbsolutePath());
        }
    }

    private void convert(File from, File to) throws IOException {
        try (BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(from), SOURCE_ENCODING));
             PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(to), "UTF-8"));){
            String line;
            out.print("<!DOCTYPE html><html><head><meta charset=\"UTF-8\" /><title>Source Code</title></head><body><pre>");
            while ((line = in.readLine()) != null) {
                StringBuilder result = new StringBuilder();
                int len = line.length();
                block23: for (int i = 0; i < len; ++i) {
                    char c = line.charAt(i);
                    switch (c) {
                        case '&': {
                            result.append("&amp;");
                            continue block23;
                        }
                        case '<': {
                            result.append("&lt;");
                            continue block23;
                        }
                        default: {
                            result.append(c);
                        }
                    }
                }
                out.print(result.toString() + LINE_SEPARATOR);
            }
            out.print("</pre></body></html>");
        }
    }
}

