/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.web.buildutil;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class CheckEol
extends Task {
    private final List<FileSet> filesets = new LinkedList<FileSet>();
    private Mode mode;

    public void addFileset(FileSet fs) {
        this.filesets.add(fs);
    }

    public void setMode(String mode) {
        this.mode = Mode.valueOf(mode.toUpperCase());
    }

    private Mode getMode() {
        if (this.mode != null) {
            return this.mode;
        }
        if ("\n".equals(System.lineSeparator())) {
            return Mode.LF;
        }
        if ("\r\n".equals(System.lineSeparator())) {
            return Mode.CRLF;
        }
        return null;
    }

    public void execute() throws BuildException {
        Mode mode = this.getMode();
        if (mode == null) {
            this.log("Line ends check skipped, because OS line ends setting is neither LF nor CRLF.", 3);
            return;
        }
        int count = 0;
        ArrayList<CheckFailure> errors = new ArrayList<CheckFailure>();
        for (FileSet fs : this.filesets) {
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            File basedir = ds.getBasedir();
            String[] files = ds.getIncludedFiles();
            if (files.length <= 0) continue;
            this.log("Checking line ends in " + files.length + " file(s)");
            for (String filename : files) {
                File file = new File(basedir, filename);
                this.log("Checking file '" + file + "' for correct line ends", 4);
                try {
                    this.check(file, errors, mode);
                }
                catch (IOException e) {
                    throw new BuildException("Could not check file '" + file.getAbsolutePath() + "'", (Throwable)e);
                }
                ++count;
            }
        }
        if (count > 0) {
            this.log("Done line ends check in " + count + " file(s), " + errors.size() + " error(s) found.");
        }
        if (errors.size() > 0) {
            String message = "The following files have wrong line ends: " + errors;
            this.log(message, 0);
            throw new BuildException(message);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void check(File file, List<CheckFailure> errors, Mode mode) throws IOException {
        try (FileInputStream fis = new FileInputStream(file);
             BufferedInputStream is = new BufferedInputStream(fis);){
            int ch;
            int line = 1;
            int prev = -1;
            while ((ch = is.read()) != -1) {
                if (ch == 10) {
                    if (mode == Mode.LF && prev == 13) {
                        errors.add(new CheckFailure(file, line, "CRLF"));
                        return;
                    }
                    if (mode == Mode.CRLF && prev != 13) {
                        errors.add(new CheckFailure(file, line, "LF"));
                        return;
                    }
                    ++line;
                } else if (prev == 13) {
                    errors.add(new CheckFailure(file, line, "CR"));
                    return;
                }
                prev = ch;
            }
            return;
        }
    }

    private static class CheckFailure {
        private final File file;
        private final int line;
        private final String value;

        public CheckFailure(File file, int line, String value) {
            this.file = file;
            this.line = line;
            this.value = value;
        }

        public String toString() {
            return System.lineSeparator() + this.file + ": uses " + this.value + " on line " + this.line;
        }
    }

    private static enum Mode {
        LF,
        CRLF;

    }
}

