/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.container.users;

import com.tongweb.container.Group;
import com.tongweb.container.Role;
import com.tongweb.container.UserDatabase;
import com.tongweb.container.users.AbstractUser;
import com.tongweb.container.users.MemoryUserDatabase;
import com.tongweb.web.util.buf.StringUtils;
import com.tongweb.web.util.security.Escape;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Iterator;

public class MemoryUser
extends AbstractUser {
    protected final MemoryUserDatabase database;
    protected final ArrayList<Group> groups = new ArrayList();
    protected final ArrayList<Role> roles = new ArrayList();

    MemoryUser(MemoryUserDatabase database, String username, String password, String fullName) {
        this.database = database;
        this.setUsername(username);
        this.setPassword(password);
        this.setFullName(fullName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Group> getGroups() {
        ArrayList<Group> arrayList = this.groups;
        synchronized (arrayList) {
            return this.groups.iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Role> getRoles() {
        ArrayList<Role> arrayList = this.roles;
        synchronized (arrayList) {
            return this.roles.iterator();
        }
    }

    @Override
    public UserDatabase getUserDatabase() {
        return this.database;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addGroup(Group group) {
        ArrayList<Group> arrayList = this.groups;
        synchronized (arrayList) {
            if (!this.groups.contains(group)) {
                this.groups.add(group);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRole(Role role) {
        ArrayList<Role> arrayList = this.roles;
        synchronized (arrayList) {
            if (!this.roles.contains(role)) {
                this.roles.add(role);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isInGroup(Group group) {
        ArrayList<Group> arrayList = this.groups;
        synchronized (arrayList) {
            return this.groups.contains(group);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isInRole(Role role) {
        ArrayList<Role> arrayList = this.roles;
        synchronized (arrayList) {
            return this.roles.contains(role);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeGroup(Group group) {
        ArrayList<Group> arrayList = this.groups;
        synchronized (arrayList) {
            this.groups.remove(group);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeGroups() {
        ArrayList<Group> arrayList = this.groups;
        synchronized (arrayList) {
            this.groups.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRole(Role role) {
        ArrayList<Role> arrayList = this.roles;
        synchronized (arrayList) {
            this.roles.remove(role);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRoles() {
        ArrayList<Role> arrayList = this.roles;
        synchronized (arrayList) {
            this.roles.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toXml() {
        StringBuilder sb = new StringBuilder("<user username=\"");
        sb.append(Escape.xml(this.username));
        sb.append("\" password=\"");
        sb.append(Escape.xml(this.password));
        sb.append("\"");
        if (this.fullName != null) {
            sb.append(" fullName=\"");
            sb.append(Escape.xml(this.fullName));
            sb.append("\"");
        }
        ArrayList<Principal> arrayList = this.groups;
        synchronized (arrayList) {
            if (this.groups.size() > 0) {
                sb.append(" groups=\"");
                StringUtils.join(this.groups, ',', x -> Escape.xml(x.getGroupname()), sb);
                sb.append("\"");
            }
        }
        arrayList = this.roles;
        synchronized (arrayList) {
            if (this.roles.size() > 0) {
                sb.append(" roles=\"");
                StringUtils.join(this.roles, ',', x -> Escape.xml(x.getRolename()), sb);
                sb.append("\"");
            }
        }
        sb.append("/>");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("User username=\"");
        sb.append(Escape.xml(this.username));
        sb.append("\"");
        if (this.fullName != null) {
            sb.append(", fullName=\"");
            sb.append(Escape.xml(this.fullName));
            sb.append("\"");
        }
        ArrayList<Principal> arrayList = this.groups;
        synchronized (arrayList) {
            if (this.groups.size() > 0) {
                sb.append(", groups=\"");
                StringUtils.join(this.groups, ',', x -> Escape.xml(x.getGroupname()), sb);
                sb.append("\"");
            }
        }
        arrayList = this.roles;
        synchronized (arrayList) {
            if (this.roles.size() > 0) {
                sb.append(", roles=\"");
                StringUtils.join(this.roles, ',', x -> Escape.xml(x.getRolename()), sb);
                sb.append("\"");
            }
        }
        return sb.toString();
    }
}

