/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.container.users;

import com.tongweb.container.Role;
import com.tongweb.container.User;
import com.tongweb.container.UserDatabase;
import com.tongweb.container.users.AbstractGroup;
import com.tongweb.container.users.MemoryUserDatabase;
import com.tongweb.web.util.buf.StringUtils;
import java.util.ArrayList;
import java.util.Iterator;

public class MemoryGroup
extends AbstractGroup {
    protected final MemoryUserDatabase database;
    protected final ArrayList<Role> roles = new ArrayList();

    MemoryGroup(MemoryUserDatabase database, String groupname, String description) {
        this.database = database;
        this.setGroupname(groupname);
        this.setDescription(description);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Role> getRoles() {
        ArrayList<Role> arrayList = this.roles;
        synchronized (arrayList) {
            return this.roles.iterator();
        }
    }

    @Override
    public UserDatabase getUserDatabase() {
        return this.database;
    }

    @Override
    public Iterator<User> getUsers() {
        ArrayList<User> results = new ArrayList<User>();
        Iterator<User> users = this.database.getUsers();
        while (users.hasNext()) {
            User user = users.next();
            if (!user.isInGroup(this)) continue;
            results.add(user);
        }
        return results.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRole(Role role) {
        ArrayList<Role> arrayList = this.roles;
        synchronized (arrayList) {
            if (!this.roles.contains(role)) {
                this.roles.add(role);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isInRole(Role role) {
        ArrayList<Role> arrayList = this.roles;
        synchronized (arrayList) {
            return this.roles.contains(role);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRole(Role role) {
        ArrayList<Role> arrayList = this.roles;
        synchronized (arrayList) {
            this.roles.remove(role);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRoles() {
        ArrayList<Role> arrayList = this.roles;
        synchronized (arrayList) {
            this.roles.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("<group groupname=\"");
        sb.append(this.groupname);
        sb.append("\"");
        if (this.description != null) {
            sb.append(" description=\"");
            sb.append(this.description);
            sb.append("\"");
        }
        ArrayList<Role> arrayList = this.roles;
        synchronized (arrayList) {
            if (this.roles.size() > 0) {
                sb.append(" roles=\"");
                StringUtils.join(this.roles, ',', Role::getRolename, sb);
                sb.append("\"");
            }
        }
        sb.append("/>");
        return sb.toString();
    }
}

