/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.container.tribes.transport;

import com.tongweb.container.tribes.Channel;
import com.tongweb.container.tribes.ChannelException;
import com.tongweb.container.tribes.ChannelMessage;
import com.tongweb.container.tribes.ChannelSender;
import com.tongweb.container.tribes.Member;
import com.tongweb.container.tribes.jmx.JmxRegistry;
import com.tongweb.container.tribes.transport.MultiPointSender;
import com.tongweb.container.tribes.transport.nio.PooledParallelSender;
import java.io.IOException;
import javax.management.ObjectName;

public class ReplicationTransmitter
implements ChannelSender {
    private Channel channel;
    private ObjectName oname = null;
    private MultiPointSender transport = new PooledParallelSender();

    public MultiPointSender getTransport() {
        return this.transport;
    }

    public void setTransport(MultiPointSender transport) {
        this.transport = transport;
    }

    @Override
    public void sendMessage(ChannelMessage message, Member[] destination) throws ChannelException {
        MultiPointSender sender = this.getTransport();
        sender.sendMessage(destination, message);
    }

    @Override
    public void start() throws IOException {
        this.getTransport().connect();
        JmxRegistry jmxRegistry = JmxRegistry.getRegistry(this.channel);
        if (jmxRegistry != null) {
            this.oname = jmxRegistry.registerJmx(",component=Sender", this.transport);
        }
    }

    @Override
    public synchronized void stop() {
        this.getTransport().disconnect();
        if (this.oname != null) {
            JmxRegistry.getRegistry(this.channel).unregisterJmx(this.oname);
            this.oname = null;
        }
        this.channel = null;
    }

    @Override
    public void heartbeat() {
        if (this.getTransport() != null) {
            this.getTransport().keepalive();
        }
    }

    @Override
    public synchronized void add(Member member) {
        this.getTransport().add(member);
    }

    @Override
    public synchronized void remove(Member member) {
        this.getTransport().remove(member);
    }

    @Override
    public Channel getChannel() {
        return this.channel;
    }

    @Override
    public void setChannel(Channel channel) {
        this.channel = channel;
    }
}

