/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.container.storeconfig;

import com.tongweb.commons.logger.logging.Log;
import com.tongweb.commons.logger.logging.LogFactory;
import com.tongweb.container.Container;
import com.tongweb.container.Context;
import com.tongweb.container.Engine;
import com.tongweb.container.Host;
import com.tongweb.container.LifecycleListener;
import com.tongweb.container.Loader;
import com.tongweb.container.Manager;
import com.tongweb.container.Realm;
import com.tongweb.container.WebResourceRoot;
import com.tongweb.container.core.StandardContext;
import com.tongweb.container.core.ThreadLocalLeakPreventionListener;
import com.tongweb.container.deploy.NamingResourcesImpl;
import com.tongweb.container.storeconfig.StoreDescription;
import com.tongweb.container.storeconfig.StoreFactoryBase;
import com.tongweb.container.storeconfig.StoreFileMover;
import com.tongweb.container.util.ContextName;
import com.tongweb.web.JarScanner;
import com.tongweb.web.util.http.CookieProcessor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;

public class StandardContextSF
extends StoreFactoryBase {
    private static Log log = LogFactory.getLog(StandardContextSF.class);

    @Override
    public void store(PrintWriter aWriter, int indent, Object aContext) throws Exception {
        StoreDescription desc;
        if (aContext instanceof StandardContext && (desc = this.getRegistry().findDescription(aContext.getClass())).isStoreSeparate()) {
            URL configFile = ((StandardContext)aContext).getConfigFile();
            if (configFile != null) {
                if (desc.isExternalAllowed()) {
                    if (desc.isBackup()) {
                        this.storeWithBackup((StandardContext)aContext);
                    } else {
                        this.storeContextSeparate(aWriter, indent, (StandardContext)aContext);
                    }
                    return;
                }
            } else if (desc.isExternalOnly()) {
                StandardContext context = (StandardContext)aContext;
                Host host = (Host)context.getParent();
                File configBase = host.getConfigBaseFile();
                ContextName cn = new ContextName(context.getName(), false);
                String baseName = cn.getBaseName();
                File xml = new File(configBase, baseName + ".xml");
                context.setConfigFile(xml.toURI().toURL());
                if (desc.isBackup()) {
                    this.storeWithBackup((StandardContext)aContext);
                } else {
                    this.storeContextSeparate(aWriter, indent, (StandardContext)aContext);
                }
                return;
            }
        }
        super.store(aWriter, indent, aContext);
    }

    protected void storeContextSeparate(PrintWriter aWriter, int indent, StandardContext aContext) throws Exception {
        block28: {
            URL configFile = aContext.getConfigFile();
            if (configFile != null) {
                File config = new File(configFile.toURI());
                if (!config.isAbsolute()) {
                    config = new File(System.getProperty("tongweb.base"), config.getPath());
                }
                if (!config.isFile() || !config.canWrite()) {
                    throw new IOException(sm.getString("standardContextSF.cannotWriteFile", configFile));
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)sm.getString("standardContextSF.storeContext", aContext.getPath(), config));
                }
                try (FileOutputStream fos = new FileOutputStream(config);
                     PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)fos, this.getRegistry().getEncoding()));){
                    this.storeXMLHead(writer);
                    super.store(writer, -2, aContext);
                    break block28;
                }
            }
            super.store(aWriter, indent, aContext);
        }
    }

    protected void storeWithBackup(StandardContext aContext) throws Exception {
        StoreFileMover mover = this.getConfigFileWriter(aContext);
        if (mover != null) {
            if (mover.getConfigOld() == null || mover.getConfigOld().isDirectory() || mover.getConfigOld().exists() && !mover.getConfigOld().canWrite()) {
                throw new IOException(sm.getString("standardContextSF.moveFailed", mover.getConfigOld()));
            }
            File dir = mover.getConfigSave().getParentFile();
            if (dir != null && dir.isDirectory() && !dir.canWrite()) {
                throw new IOException(sm.getString("standardContextSF.cannotWriteFile", mover.getConfigSave()));
            }
            if (log.isInfoEnabled()) {
                log.info((Object)sm.getString("standardContextSF.storeContextWithBackup", aContext.getPath(), mover.getConfigSave()));
            }
            try (PrintWriter writer = mover.getWriter();){
                this.storeXMLHead(writer);
                super.store(writer, -2, aContext);
            }
            mover.move();
        }
    }

    protected StoreFileMover getConfigFileWriter(Context context) throws Exception {
        URL configFile = context.getConfigFile();
        StoreFileMover mover = null;
        if (configFile != null) {
            File config = new File(configFile.toURI());
            if (!config.isAbsolute()) {
                config = new File(System.getProperty("tongweb.base"), config.getPath());
            }
            mover = new StoreFileMover("", config.getCanonicalPath(), this.getRegistry().getEncoding());
        }
        return mover;
    }

    @Override
    public void storeChildren(PrintWriter aWriter, int indent, Object aContext, StoreDescription parentDesc) throws Exception {
        if (aContext instanceof StandardContext) {
            Realm realm;
            StandardContext context = (StandardContext)aContext;
            LifecycleListener[] listeners = context.findLifecycleListeners();
            ArrayList<LifecycleListener> listenersArray = new ArrayList<LifecycleListener>();
            for (LifecycleListener listener : listeners) {
                if (listener instanceof ThreadLocalLeakPreventionListener) continue;
                listenersArray.add(listener);
            }
            this.storeElementArray(aWriter, indent, listenersArray.toArray());
            Object[] valves = context.getPipeline().getValves();
            this.storeElementArray(aWriter, indent, valves);
            Loader loader = context.getLoader();
            this.storeElement(aWriter, indent, loader);
            if (context.getCluster() == null || !context.getDistributable()) {
                Manager manager = context.getManager();
                this.storeElement(aWriter, indent, manager);
            }
            if ((realm = context.getRealm()) != null) {
                Realm parentRealm = null;
                if (context.getParent() != null) {
                    parentRealm = context.getParent().getRealm();
                }
                if (realm != parentRealm) {
                    this.storeElement(aWriter, indent, realm);
                }
            }
            WebResourceRoot resources = context.getResources();
            this.storeElement(aWriter, indent, resources);
            String[] wLifecycles = context.findWrapperLifecycles();
            this.getStoreAppender().printTagArray(aWriter, "WrapperListener", indent + 2, wLifecycles);
            String[] wListeners = context.findWrapperListeners();
            this.getStoreAppender().printTagArray(aWriter, "WrapperLifecycle", indent + 2, wListeners);
            Object[] appParams = context.findApplicationParameters();
            this.storeElementArray(aWriter, indent, appParams);
            NamingResourcesImpl nresources = context.getNamingResources();
            this.storeElement(aWriter, indent, nresources);
            String[] wresources = context.findWatchedResources();
            wresources = this.filterWatchedResources(context, wresources);
            this.getStoreAppender().printTagArray(aWriter, "WatchedResource", indent + 2, wresources);
            JarScanner jarScanner = context.getJarScanner();
            this.storeElement(aWriter, indent, jarScanner);
            CookieProcessor cookieProcessor = context.getCookieProcessor();
            this.storeElement(aWriter, indent, cookieProcessor);
        }
    }

    protected File configBase(Context context) {
        File file = new File(System.getProperty("tongweb.base"), "conf");
        Container host = context.getParent();
        if (host instanceof Host) {
            Container engine = host.getParent();
            if (engine instanceof Engine) {
                file = new File(file, engine.getName());
            }
            file = new File(file, host.getName());
            try {
                file = file.getCanonicalFile();
            }
            catch (IOException e) {
                log.error((Object)sm.getString("standardContextSF.canonicalPathError"), (Throwable)e);
            }
        }
        return file;
    }

    protected String[] filterWatchedResources(StandardContext context, String[] wresources) throws Exception {
        File configBase = this.configBase(context);
        String confContext = new File(System.getProperty("tongweb.base"), "conf/context.xml").getCanonicalPath();
        String confWeb = new File(System.getProperty("tongweb.base"), "conf/web.xml").getCanonicalPath();
        String confHostDefault = new File(configBase, "context.xml.default").getCanonicalPath();
        String configFile = context.getConfigFile() != null ? new File(context.getConfigFile().toURI()).getCanonicalPath() : null;
        String webxml = "WEB-INF/web.xml";
        String tomcatwebxml = "WEB-INF/tongweb-web.xml";
        ArrayList<String> resource = new ArrayList<String>();
        for (String wresource : wresources) {
            if (wresource.equals(confContext) || wresource.equals(confWeb) || wresource.equals(confHostDefault) || wresource.equals(configFile) || wresource.equals(webxml) || wresource.equals(tomcatwebxml)) continue;
            resource.add(wresource);
        }
        return resource.toArray(new String[0]);
    }
}

