/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.container.storeconfig;

import com.tongweb.commons.logger.logging.Log;
import com.tongweb.commons.logger.logging.LogFactory;
import com.tongweb.container.CredentialHandler;
import com.tongweb.container.Realm;
import com.tongweb.container.realm.CombinedRealm;
import com.tongweb.container.storeconfig.StoreDescription;
import com.tongweb.container.storeconfig.StoreFactoryBase;
import java.io.PrintWriter;

public class RealmSF
extends StoreFactoryBase {
    private static Log log = LogFactory.getLog(RealmSF.class);

    @Override
    public void store(PrintWriter aWriter, int indent, Object aElement) throws Exception {
        if (aElement instanceof CombinedRealm) {
            StoreDescription elementDesc = this.getRegistry().findDescription(aElement.getClass());
            if (elementDesc != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("factory.storeTag", elementDesc.getTag(), aElement));
                }
                this.getStoreAppender().printIndent(aWriter, indent + 2);
                this.getStoreAppender().printOpenTag(aWriter, indent + 2, aElement, elementDesc);
                this.storeChildren(aWriter, indent + 2, aElement, elementDesc);
                this.getStoreAppender().printIndent(aWriter, indent + 2);
                this.getStoreAppender().printCloseTag(aWriter, elementDesc);
            } else if (log.isWarnEnabled()) {
                log.warn((Object)sm.getString("factory.storeNoDescriptor", aElement.getClass()));
            }
        } else {
            super.store(aWriter, indent, aElement);
        }
    }

    @Override
    public void storeChildren(PrintWriter aWriter, int indent, Object aRealm, StoreDescription parentDesc) throws Exception {
        CredentialHandler credentialHandler;
        if (aRealm instanceof CombinedRealm) {
            CombinedRealm combinedRealm = (CombinedRealm)aRealm;
            Object[] realms = combinedRealm.getNestedRealms();
            this.storeElementArray(aWriter, indent, realms);
        }
        if ((credentialHandler = ((Realm)aRealm).getCredentialHandler()) != null) {
            this.storeElement(aWriter, indent, credentialHandler);
        }
    }
}

