/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.container.storeconfig;

import com.tongweb.commons.logger.logging.Log;
import com.tongweb.commons.logger.logging.LogFactory;
import com.tongweb.container.Manager;
import com.tongweb.container.SessionIdGenerator;
import com.tongweb.container.session.StandardManager;
import com.tongweb.container.storeconfig.StoreDescription;
import com.tongweb.container.storeconfig.StoreFactoryBase;
import java.io.PrintWriter;

public class ManagerSF
extends StoreFactoryBase {
    private static Log log = LogFactory.getLog(ManagerSF.class);

    @Override
    public void store(PrintWriter aWriter, int indent, Object aElement) throws Exception {
        StoreDescription elementDesc = this.getRegistry().findDescription(aElement.getClass());
        if (elementDesc != null) {
            if (aElement instanceof StandardManager) {
                StandardManager manager = (StandardManager)aElement;
                if (!this.isDefaultManager(manager)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)sm.getString("factory.storeTag", elementDesc.getTag(), aElement));
                    }
                    super.store(aWriter, indent, aElement);
                }
            } else {
                super.store(aWriter, indent, aElement);
            }
        } else if (log.isWarnEnabled()) {
            log.warn((Object)sm.getString("factory.storeNoDescriptor", aElement.getClass()));
        }
    }

    protected boolean isDefaultManager(StandardManager smanager) {
        return "SESSIONS.ser".equals(smanager.getPathname()) && smanager.getMaxActiveSessions() == -1;
    }

    @Override
    public void storeChildren(PrintWriter aWriter, int indent, Object aManager, StoreDescription parentDesc) throws Exception {
        Manager manager;
        SessionIdGenerator sessionIdGenerator;
        if (aManager instanceof Manager && (sessionIdGenerator = (manager = (Manager)aManager).getSessionIdGenerator()) != null) {
            this.storeElement(aWriter, indent, sessionIdGenerator);
        }
    }
}

