/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.container.startup;

import com.tongweb.container.startup.UserConfig;
import com.tongweb.container.startup.UserDatabase;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;

public final class HomesUserDatabase
implements UserDatabase {
    private final Hashtable<String, String> homes = new Hashtable();
    private UserConfig userConfig = null;

    @Override
    public UserConfig getUserConfig() {
        return this.userConfig;
    }

    @Override
    public void setUserConfig(UserConfig userConfig) {
        this.userConfig = userConfig;
        this.init();
    }

    @Override
    public String getHome(String user) {
        return this.homes.get(user);
    }

    @Override
    public Enumeration<String> getUsers() {
        return this.homes.keys();
    }

    private void init() {
        String homeBase = this.userConfig.getHomeBase();
        File homeBaseDir = new File(homeBase);
        if (!homeBaseDir.exists() || !homeBaseDir.isDirectory()) {
            return;
        }
        String[] homeBaseFiles = homeBaseDir.list();
        if (homeBaseFiles == null) {
            return;
        }
        for (String homeBaseFile : homeBaseFiles) {
            File homeDir = new File(homeBaseDir, homeBaseFile);
            if (!homeDir.isDirectory() || !homeDir.canRead()) continue;
            this.homes.put(homeBaseFile, homeDir.toString());
        }
    }
}

