/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.container.startup;

import com.tongweb.commons.logger.logging.Log;
import com.tongweb.commons.logger.logging.LogFactory;
import com.tongweb.container.Engine;
import com.tongweb.container.LifecycleEvent;
import com.tongweb.container.LifecycleListener;
import com.tongweb.web.util.res.StringManager;

public class EngineConfig
implements LifecycleListener {
    private static final Log log = LogFactory.getLog(EngineConfig.class);
    protected Engine engine = null;
    protected static final StringManager sm = StringManager.getManager("com.tongweb.container.startup");

    @Override
    public void lifecycleEvent(LifecycleEvent event) {
        try {
            this.engine = (Engine)event.getLifecycle();
        }
        catch (ClassCastException e) {
            log.error((Object)sm.getString("engineConfig.cce", event.getLifecycle()), (Throwable)e);
            return;
        }
        if (event.getType().equals("start")) {
            this.start();
        } else if (event.getType().equals("stop")) {
            this.stop();
        }
    }

    protected void start() {
        if (this.engine.getLogger().isDebugEnabled()) {
            this.engine.getLogger().debug((Object)sm.getString("engineConfig.start"));
        }
    }

    protected void stop() {
        if (this.engine.getLogger().isDebugEnabled()) {
            this.engine.getLogger().debug((Object)sm.getString("engineConfig.stop"));
        }
    }
}

