/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.container.servlets;

import com.tongweb.container.WebResource;
import com.tongweb.container.servlets.TWGzipOutputStream;
import java.io.ByteArrayOutputStream;

public class GzipOptimize {
    public static boolean optimize = Boolean.valueOf(System.getProperty("optimize-static", "false"));
    private static final boolean forceUseSendfileEnabled = Boolean.getBoolean("forceUseSendfile");
    public static int gzipCompressLevel = 9;

    public static byte[] gzipCompress(byte[] src) {
        if (src == null) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            TWGzipOutputStream gzip = new TWGzipOutputStream(out);
            gzip.setLevel(gzipCompressLevel);
            gzip.write(src);
            gzip.finish();
            gzip.flush();
            gzip.close();
        }
        catch (Exception ex) {
            return null;
        }
        return out.toByteArray();
    }

    public static boolean useCompress(WebResource resource) {
        if (forceUseSendfileEnabled) {
            return false;
        }
        boolean compress = false;
        String mimeType = resource.getMimeType();
        if (mimeType == null || mimeType.startsWith("text") || mimeType.endsWith("xml") || mimeType.contains("/javascript")) {
            compress = true;
        }
        return compress;
    }
}

