/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.container.ha.tcp;

import com.tongweb.commons.logger.logging.Log;
import com.tongweb.commons.logger.logging.LogFactory;
import com.tongweb.container.Cluster;
import com.tongweb.container.Context;
import com.tongweb.container.LifecycleException;
import com.tongweb.container.Manager;
import com.tongweb.container.Session;
import com.tongweb.container.connector.Request;
import com.tongweb.container.connector.Response;
import com.tongweb.container.core.StandardContext;
import com.tongweb.container.ha.CatalinaCluster;
import com.tongweb.container.ha.ClusterManager;
import com.tongweb.container.ha.ClusterMessage;
import com.tongweb.container.ha.ClusterSession;
import com.tongweb.container.ha.ClusterValve;
import com.tongweb.container.ha.session.DeltaManager;
import com.tongweb.container.ha.session.DeltaSession;
import com.tongweb.container.valves.ValveBase;
import com.tongweb.web.util.res.StringManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.ServletException;

public class ReplicationValve
extends ValveBase
implements ClusterValve {
    private static final Log log = LogFactory.getLog(ReplicationValve.class);
    protected static final StringManager sm = StringManager.getManager("com.tongweb.container.ha.tcp");
    private CatalinaCluster cluster = null;
    protected Pattern filter = null;
    protected final ThreadLocal<ArrayList<DeltaSession>> crossContextSessions = new ThreadLocal();
    protected boolean doProcessingStats = false;
    protected volatile long totalRequestTime = 0L;
    protected volatile long totalSendTime = 0L;
    protected volatile long nrOfRequests = 0L;
    protected volatile long lastSendTime = 0L;
    protected volatile long nrOfFilterRequests = 0L;
    protected volatile long nrOfSendRequests = 0L;
    protected volatile long nrOfCrossContextSendRequests = 0L;
    protected boolean primaryIndicator = false;
    protected String primaryIndicatorName = "com.tongweb.container.ha.tcp.isPrimarySession";

    public ReplicationValve() {
        super(true);
    }

    @Override
    public CatalinaCluster getCluster() {
        return this.cluster;
    }

    @Override
    public void setCluster(CatalinaCluster cluster) {
        this.cluster = cluster;
    }

    public String getFilter() {
        if (this.filter == null) {
            return null;
        }
        return this.filter.toString();
    }

    public void setFilter(String filter) {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("ReplicationValve.filter.loading", filter));
        }
        if (filter == null || filter.length() == 0) {
            this.filter = null;
        } else {
            try {
                this.filter = Pattern.compile(filter);
            }
            catch (PatternSyntaxException pse) {
                log.error((Object)sm.getString("ReplicationValve.filter.failure", filter), (Throwable)pse);
            }
        }
    }

    public boolean isPrimaryIndicator() {
        return this.primaryIndicator;
    }

    public void setPrimaryIndicator(boolean primaryIndicator) {
        this.primaryIndicator = primaryIndicator;
    }

    public String getPrimaryIndicatorName() {
        return this.primaryIndicatorName;
    }

    public void setPrimaryIndicatorName(String primaryIndicatorName) {
        this.primaryIndicatorName = primaryIndicatorName;
    }

    public boolean doStatistics() {
        return this.doProcessingStats;
    }

    public void setStatistics(boolean doProcessingStats) {
        this.doProcessingStats = doProcessingStats;
    }

    public long getLastSendTime() {
        return this.lastSendTime;
    }

    public long getNrOfRequests() {
        return this.nrOfRequests;
    }

    public long getNrOfFilterRequests() {
        return this.nrOfFilterRequests;
    }

    public long getNrOfCrossContextSendRequests() {
        return this.nrOfCrossContextSendRequests;
    }

    public long getNrOfSendRequests() {
        return this.nrOfSendRequests;
    }

    public long getTotalRequestTime() {
        return this.totalRequestTime;
    }

    public long getTotalSendTime() {
        return this.totalSendTime;
    }

    public void registerReplicationSession(DeltaSession session) {
        List sessions = this.crossContextSessions.get();
        if (sessions != null && !sessions.contains(session)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("ReplicationValve.crossContext.registerSession", session.getIdInternal(), session.getManager().getContext().getName()));
            }
            sessions.add(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke(Request request, Response response) throws IOException, ServletException {
        Context context;
        long totalstart = 0L;
        if (this.doStatistics()) {
            totalstart = System.currentTimeMillis();
        }
        if (this.primaryIndicator) {
            this.createPrimaryIndicator(request);
        }
        boolean isCrossContext = (context = request.getContext()) != null && context instanceof StandardContext && context.getCrossContext();
        try {
            if (isCrossContext) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("ReplicationValve.crossContext.add"));
                }
                this.crossContextSessions.set(new ArrayList());
            }
            this.getNext().invoke(request, response);
            if (context != null && this.cluster != null && context.getManager() instanceof ClusterManager) {
                ClusterManager clusterManager = (ClusterManager)context.getManager();
                if (this.cluster.getManager(clusterManager.getName()) == null) {
                    return;
                }
                if (this.cluster.hasMembers()) {
                    this.sendReplicationMessage(request, totalstart, isCrossContext, clusterManager);
                } else {
                    this.resetReplicationRequest(request, isCrossContext);
                }
            }
        }
        finally {
            if (isCrossContext) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("ReplicationValve.crossContext.remove"));
                }
                this.crossContextSessions.set(null);
            }
        }
    }

    public void resetStatistics() {
        this.totalRequestTime = 0L;
        this.totalSendTime = 0L;
        this.lastSendTime = 0L;
        this.nrOfFilterRequests = 0L;
        this.nrOfRequests = 0L;
        this.nrOfSendRequests = 0L;
        this.nrOfCrossContextSendRequests = 0L;
    }

    @Override
    protected synchronized void startInternal() throws LifecycleException {
        if (this.cluster == null) {
            Cluster containerCluster = this.getContainer().getCluster();
            if (containerCluster instanceof CatalinaCluster) {
                this.setCluster((CatalinaCluster)containerCluster);
            } else if (log.isWarnEnabled()) {
                log.warn((Object)sm.getString("ReplicationValve.nocluster"));
            }
        }
        super.startInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendReplicationMessage(Request request, long totalstart, boolean isCrossContext, ClusterManager clusterManager) {
        long start = 0L;
        if (this.doStatistics()) {
            start = System.currentTimeMillis();
        }
        try {
            if (!(clusterManager instanceof DeltaManager)) {
                this.sendInvalidSessions(clusterManager);
            }
            this.sendSessionReplicationMessage(request, clusterManager);
            if (isCrossContext) {
                this.sendCrossContextSession();
            }
        }
        catch (Exception x) {
            log.error((Object)sm.getString("ReplicationValve.send.failure"), (Throwable)x);
        }
        finally {
            if (this.doStatistics()) {
                this.updateStats(totalstart, start);
            }
        }
    }

    protected void sendCrossContextSession() {
        List sessions = this.crossContextSessions.get();
        if (sessions != null && sessions.size() > 0) {
            for (DeltaSession session : sessions) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("ReplicationValve.crossContext.sendDelta", session.getManager().getContext().getName()));
                }
                this.sendMessage(session, (ClusterManager)session.getManager());
                if (!this.doStatistics()) continue;
                ++this.nrOfCrossContextSendRequests;
            }
        }
    }

    protected void resetReplicationRequest(Request request, boolean isCrossContext) {
        List sessions;
        Session contextSession = request.getSessionInternal(false);
        if (contextSession instanceof DeltaSession) {
            this.resetDeltaRequest(contextSession);
            ((DeltaSession)contextSession).setPrimarySession(true);
        }
        if (isCrossContext && (sessions = (List)this.crossContextSessions.get()) != null && sessions.size() > 0) {
            for (Session session : sessions) {
                this.resetDeltaRequest(session);
                if (!(session instanceof DeltaSession)) continue;
                ((DeltaSession)contextSession).setPrimarySession(true);
            }
        }
    }

    protected void resetDeltaRequest(Session session) {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("ReplicationValve.resetDeltaRequest", session.getManager().getContext().getName()));
        }
        ((DeltaSession)session).resetDeltaRequest();
    }

    protected void sendSessionReplicationMessage(Request request, ClusterManager manager) {
        Session session = request.getSessionInternal(false);
        if (session != null) {
            String uri = request.getDecodedRequestURI();
            if (!this.isRequestWithoutSessionChange(uri)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("ReplicationValve.invoke.uri", uri));
                }
                this.sendMessage(session, manager);
            } else if (this.doStatistics()) {
                ++this.nrOfFilterRequests;
            }
        }
    }

    protected void sendMessage(Session session, ClusterManager manager) {
        String id = session.getIdInternal();
        if (id != null) {
            this.send(manager, id);
        }
    }

    protected void send(ClusterManager manager, String sessionId) {
        ClusterMessage msg = manager.requestCompleted(sessionId);
        if (msg != null && this.cluster != null) {
            this.cluster.send(msg);
            if (this.doStatistics()) {
                ++this.nrOfSendRequests;
            }
        }
    }

    protected void sendInvalidSessions(ClusterManager manager) {
        String[] invalidIds = manager.getInvalidatedSessions();
        if (invalidIds.length > 0) {
            for (String invalidId : invalidIds) {
                try {
                    this.send(manager, invalidId);
                }
                catch (Exception x) {
                    log.error((Object)sm.getString("ReplicationValve.send.invalid.failure", invalidId), (Throwable)x);
                }
            }
        }
    }

    protected boolean isRequestWithoutSessionChange(String uri) {
        Pattern f = this.filter;
        return f != null && f.matcher(uri).matches();
    }

    protected void updateStats(long requestTime, long clusterTime) {
        long currentTime;
        this.lastSendTime = currentTime = System.currentTimeMillis();
        this.totalSendTime += currentTime - clusterTime;
        this.totalRequestTime += currentTime - requestTime;
        ++this.nrOfRequests;
        if (log.isInfoEnabled() && this.nrOfRequests % 100L == 0L) {
            log.info((Object)sm.getString("ReplicationValve.stats", this.totalRequestTime / this.nrOfRequests, this.totalSendTime / this.nrOfRequests, this.nrOfRequests, this.nrOfSendRequests, this.nrOfCrossContextSendRequests, this.nrOfFilterRequests, this.totalRequestTime, this.totalSendTime));
        }
    }

    protected void createPrimaryIndicator(Request request) throws IOException {
        String id = request.getRequestedSessionId();
        if (id != null && id.length() > 0) {
            Manager manager = request.getContext().getManager();
            Session session = manager.findSession(id);
            if (session instanceof ClusterSession) {
                ClusterSession cses = (ClusterSession)session;
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("ReplicationValve.session.indicator", request.getContext().getName(), id, this.primaryIndicatorName, cses.isPrimarySession()));
                }
                request.setAttribute(this.primaryIndicatorName, cses.isPrimarySession() ? Boolean.TRUE : Boolean.FALSE);
            } else if (log.isDebugEnabled()) {
                if (session != null) {
                    log.debug((Object)sm.getString("ReplicationValve.session.found", request.getContext().getName(), id));
                } else {
                    log.debug((Object)sm.getString("ReplicationValve.session.invalid", request.getContext().getName(), id));
                }
            }
        }
    }
}

