/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.container.ha.authenticator;

import com.tongweb.container.Container;
import com.tongweb.container.Host;
import com.tongweb.container.LifecycleException;
import com.tongweb.container.Session;
import com.tongweb.container.SessionListener;
import com.tongweb.container.authenticator.SingleSignOn;
import com.tongweb.container.ha.CatalinaCluster;
import com.tongweb.container.ha.ClusterValve;
import com.tongweb.container.ha.authenticator.ClusterSingleSignOnListener;
import com.tongweb.container.tribes.tipis.AbstractReplicatedMap;
import com.tongweb.container.tribes.tipis.ReplicatedMap;
import com.tongweb.web.util.ExceptionUtils;
import com.tongweb.web.util.res.StringManager;
import java.security.Principal;

public class ClusterSingleSignOn
extends SingleSignOn
implements ClusterValve,
AbstractReplicatedMap.MapOwner {
    private static final StringManager sm = StringManager.getManager(ClusterSingleSignOn.class);
    private CatalinaCluster cluster = null;
    private long rpcTimeout = 15000L;
    private int mapSendOptions = 6;
    private boolean terminateOnStartFailure = false;
    private long accessTimeout = 5000L;

    @Override
    public CatalinaCluster getCluster() {
        return this.cluster;
    }

    @Override
    public void setCluster(CatalinaCluster cluster) {
        this.cluster = cluster;
    }

    public long getRpcTimeout() {
        return this.rpcTimeout;
    }

    public void setRpcTimeout(long rpcTimeout) {
        this.rpcTimeout = rpcTimeout;
    }

    public int getMapSendOptions() {
        return this.mapSendOptions;
    }

    public void setMapSendOptions(int mapSendOptions) {
        this.mapSendOptions = mapSendOptions;
    }

    public boolean getTerminateOnStartFailure() {
        return this.terminateOnStartFailure;
    }

    public void setTerminateOnStartFailure(boolean terminateOnStartFailure) {
        this.terminateOnStartFailure = terminateOnStartFailure;
    }

    public long getAccessTimeout() {
        return this.accessTimeout;
    }

    public void setAccessTimeout(long accessTimeout) {
        this.accessTimeout = accessTimeout;
    }

    @Override
    protected boolean associate(String ssoId, Session session) {
        boolean result = super.associate(ssoId, session);
        if (result) {
            ((ReplicatedMap)this.cache).replicate(ssoId, true);
        }
        return result;
    }

    @Override
    protected boolean update(String ssoId, Principal principal, String authType, String username, String password) {
        boolean result = super.update(ssoId, principal, authType, username, password);
        if (result) {
            ((ReplicatedMap)this.cache).replicate(ssoId, true);
        }
        return result;
    }

    @Override
    protected SessionListener getSessionListener(String ssoId) {
        return new ClusterSingleSignOnListener(ssoId);
    }

    @Override
    public void objectMadePrimary(Object key, Object value) {
    }

    @Override
    protected synchronized void startInternal() throws LifecycleException {
        try {
            Container host;
            if (this.cluster == null && (host = this.getContainer()) instanceof Host && host.getCluster() instanceof CatalinaCluster) {
                this.setCluster((CatalinaCluster)host.getCluster());
            }
            if (this.cluster == null) {
                throw new LifecycleException(sm.getString("clusterSingleSignOn.nocluster"));
            }
            ClassLoader[] cls = new ClassLoader[]{this.getClass().getClassLoader()};
            ReplicatedMap cache = new ReplicatedMap((AbstractReplicatedMap.MapOwner)this, this.cluster.getChannel(), this.rpcTimeout, this.cluster.getClusterName() + "-SSO-cache", cls, this.terminateOnStartFailure);
            cache.setChannelSendOptions(this.mapSendOptions);
            cache.setAccessTimeout(this.accessTimeout);
            this.cache = cache;
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            throw new LifecycleException(sm.getString("clusterSingleSignOn.clusterLoad.fail"), t);
        }
        super.startInternal();
    }

    @Override
    protected synchronized void stopInternal() throws LifecycleException {
        super.stopInternal();
        if (this.getCluster() != null) {
            ((ReplicatedMap)this.cache).breakdown();
        }
    }
}

