/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.container.filters;

import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class HostHeaderSecurityFilter {
    private static HostHeaderSecurityFilter inst;

    public static HostHeaderSecurityFilter getInst() {
        if (inst == null) {
            inst = new HostHeaderSecurityFilter();
        }
        return inst;
    }

    private HostHeaderSecurityFilter() {
    }

    public boolean filter(HttpServletRequest request) {
        HostHeaderGuardConfig config = this.getConfig();
        if (!config.enabled) {
            return true;
        }
        String requestURI = request.getRequestURI();
        if (requestURI != null && System.getProperty("server.uri") != null && System.getProperty("server.uri").length() != 0 && requestURI.contains(System.getProperty("server.uri"))) {
            return true;
        }
        String requestHost = request.getHeader("host");
        if (requestHost != null && requestHost.indexOf(":") > 0) {
            String[] splitRequestHost = requestHost.split(":");
            requestHost = splitRequestHost[0];
        }
        if (!Boolean.getBoolean("server.hostHeader.strict") && requestHost != null && (requestHost.equals("localhost") || requestHost.startsWith("127.0.0."))) {
            return true;
        }
        return requestHost == null || config.whiteList.contains(requestHost);
    }

    private HostHeaderGuardConfig getConfig() {
        HostHeaderGuardConfig config = new HostHeaderGuardConfig();
        if (!"true".equals(System.getProperty("server.hostHeader.security"))) {
            config.enabled = false;
            return config;
        }
        config.enabled = true;
        String whiteList = System.getProperty("server.hostHeader.allow.list");
        String[] splitWhiteList = whiteList.split(",");
        config.whiteList = Arrays.asList(splitWhiteList);
        return config;
    }

    class HostHeaderGuardConfig {
        public boolean enabled;
        public List<String> whiteList;

        HostHeaderGuardConfig() {
        }
    }
}

