/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.connector.http2;

import com.tongweb.commons.logger.logging.Log;
import com.tongweb.commons.logger.logging.LogFactory;
import com.tongweb.connector.AbstractProcessor;
import com.tongweb.connector.ActionCode;
import com.tongweb.connector.Adapter;
import com.tongweb.connector.ContainerThreadMarker;
import com.tongweb.connector.ContinueResponseTiming;
import com.tongweb.connector.ErrorState;
import com.tongweb.connector.Request;
import com.tongweb.connector.RequestGroupInfo;
import com.tongweb.connector.Response;
import com.tongweb.connector.http11.filters.GzipOutputFilter;
import com.tongweb.connector.http2.ConnectionException;
import com.tongweb.connector.http2.Http2Error;
import com.tongweb.connector.http2.Http2Protocol;
import com.tongweb.connector.http2.Http2UpgradeHandler;
import com.tongweb.connector.http2.SendfileData;
import com.tongweb.connector.http2.Stream;
import com.tongweb.connector.http2.StreamException;
import com.tongweb.web.util.buf.ByteChunk;
import com.tongweb.web.util.http.FastHttpDateFormat;
import com.tongweb.web.util.http.MimeHeaders;
import com.tongweb.web.util.net.AbstractEndpoint;
import com.tongweb.web.util.net.DispatchType;
import com.tongweb.web.util.net.SendfileState;
import com.tongweb.web.util.net.SocketEvent;
import com.tongweb.web.util.net.SocketWrapperBase;
import com.tongweb.web.util.res.StringManager;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;

class StreamProcessor
extends AbstractProcessor {
    private static final Log log = LogFactory.getLog(StreamProcessor.class);
    private static final StringManager sm = StringManager.getManager(StreamProcessor.class);
    private final Http2UpgradeHandler handler;
    private final Stream stream;
    private SendfileData sendfileData = null;
    private SendfileState sendfileState = null;

    StreamProcessor(Http2UpgradeHandler handler, Stream stream, Adapter adapter, SocketWrapperBase<?> socketWrapper) {
        super(adapter, stream.getCoyoteRequest(), stream.getCoyoteResponse());
        this.handler = handler;
        this.stream = stream;
        this.setSocketWrapper(socketWrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void process(SocketEvent event) {
        try {
            StreamProcessor streamProcessor = this;
            synchronized (streamProcessor) {
                ContainerThreadMarker.set();
                AbstractEndpoint.Handler.SocketState state = AbstractEndpoint.Handler.SocketState.CLOSED;
                try {
                    state = this.process(this.socketWrapper, event);
                    if (state == AbstractEndpoint.Handler.SocketState.LONG) {
                        this.handler.getProtocol().getHttp11Protocol().addWaitingProcessor(this);
                    } else if (state == AbstractEndpoint.Handler.SocketState.CLOSED) {
                        this.handler.getProtocol().getHttp11Protocol().removeWaitingProcessor(this);
                        if (!this.getErrorState().isConnectionIoAllowed()) {
                            ConnectionException ce = new ConnectionException(sm.getString("streamProcessor.error.connection", this.stream.getConnectionId(), this.stream.getIdAsString()), Http2Error.INTERNAL_ERROR);
                            this.stream.close(ce);
                        } else if (!this.getErrorState().isIoAllowed()) {
                            StreamException se = this.stream.getResetException();
                            if (se == null) {
                                se = new StreamException(sm.getString("streamProcessor.error.stream", this.stream.getConnectionId(), this.stream.getIdAsString()), Http2Error.INTERNAL_ERROR, this.stream.getIdAsInt());
                            }
                            this.stream.close(se);
                        } else if (!this.stream.isActive()) {
                            this.stream.recycle();
                        }
                    }
                }
                catch (Exception e) {
                    String msg = sm.getString("streamProcessor.error.connection", this.stream.getConnectionId(), this.stream.getIdAsString());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)msg, (Throwable)e);
                    }
                    ConnectionException ce = new ConnectionException(msg, Http2Error.INTERNAL_ERROR, e);
                    this.stream.close(ce);
                    state = AbstractEndpoint.Handler.SocketState.CLOSED;
                }
                finally {
                    if (state == AbstractEndpoint.Handler.SocketState.CLOSED) {
                        this.recycle();
                    }
                    ContainerThreadMarker.clear();
                }
            }
        }
        finally {
            this.handler.executeQueuedStream();
        }
    }

    @Override
    protected final void prepareResponse() throws IOException {
        this.response.setCommitted(true);
        if (this.handler.hasAsyncIO() && this.handler.getProtocol().getUseSendfile()) {
            this.prepareSendfile();
        }
        StreamProcessor.prepareHeaders(this.request, this.response, this.sendfileData == null, this.handler.getProtocol(), this.stream);
        this.stream.writeHeaders();
    }

    private void prepareSendfile() {
        String fileName = (String)this.stream.getCoyoteRequest().getAttribute("com.tongweb.web.sendfile.filename");
        if (fileName != null) {
            this.sendfileData = new SendfileData();
            this.sendfileData.path = new File(fileName).toPath();
            this.sendfileData.pos = (Long)this.stream.getCoyoteRequest().getAttribute("com.tongweb.web.sendfile.start");
            this.sendfileData.end = (Long)this.stream.getCoyoteRequest().getAttribute("com.tongweb.web.sendfile.end");
            this.sendfileData.left = this.sendfileData.end - this.sendfileData.pos;
            this.sendfileData.stream = this.stream;
        }
    }

    static void prepareHeaders(Request coyoteRequest, Response coyoteResponse, boolean noSendfile, Http2Protocol protocol, Stream stream) {
        MimeHeaders headers = coyoteResponse.getMimeHeaders();
        int statusCode = coyoteResponse.getStatus();
        headers.addValue(":status").setString(Integer.toString(statusCode));
        if (noSendfile && protocol != null && protocol.useCompression(coyoteRequest, coyoteResponse)) {
            stream.addOutputFilter(new GzipOutputFilter());
        }
        if (statusCode >= 200 && statusCode != 204 && statusCode != 205 && statusCode != 304) {
            long contentLength;
            String contentLanguage;
            String contentType = coyoteResponse.getContentType();
            if (contentType != null) {
                headers.setValue("content-type").setString(contentType);
            }
            if ((contentLanguage = coyoteResponse.getContentLanguage()) != null) {
                headers.setValue("content-language").setString(contentLanguage);
            }
            if ((contentLength = coyoteResponse.getContentLengthLong()) != -1L && headers.getValue("content-length") == null) {
                headers.addValue("content-length").setLong(contentLength);
            }
        } else if (statusCode == 205) {
            coyoteResponse.setContentLength(0L);
        } else {
            coyoteResponse.setContentLength(-1L);
        }
        if (statusCode >= 200 && headers.getValue("date") == null) {
            headers.addValue("date").setString(FastHttpDateFormat.getCurrentDate());
        }
    }

    @Override
    protected final void finishResponse() throws IOException {
        this.sendfileState = this.handler.processSendfile(this.sendfileData);
        if (this.sendfileState != SendfileState.PENDING) {
            this.stream.getOutputBuffer().end();
        }
    }

    @Override
    protected final void ack(ContinueResponseTiming continueResponseTiming) {
        if ((continueResponseTiming == ContinueResponseTiming.ALWAYS || continueResponseTiming == this.handler.getProtocol().getContinueResponseTimingInternal()) && !this.response.isCommitted() && this.request.hasExpectation()) {
            try {
                this.stream.writeAck();
            }
            catch (IOException ioe) {
                this.setErrorState(ErrorState.CLOSE_CONNECTION_NOW, ioe);
            }
        }
    }

    @Override
    protected final void flush() throws IOException {
        this.stream.getOutputBuffer().flush();
    }

    @Override
    protected final int available(boolean doRead) {
        return this.stream.getInputBuffer().available();
    }

    @Override
    protected final void setRequestBody(ByteChunk body) {
        this.stream.getInputBuffer().insertReplayedBody(body);
        try {
            this.stream.receivedEndOfStream();
        }
        catch (ConnectionException connectionException) {
            // empty catch block
        }
    }

    @Override
    protected final void setSwallowResponse() {
    }

    @Override
    protected final void disableSwallowRequest() {
    }

    @Override
    protected void processSocketEvent(SocketEvent event, boolean dispatch) {
        if (dispatch) {
            this.handler.processStreamOnContainerThread(this, event);
        } else {
            this.process(event);
        }
    }

    @Override
    protected final boolean isReadyForRead() {
        return this.stream.getInputBuffer().isReadyForRead();
    }

    @Override
    protected final boolean isRequestBodyFullyRead() {
        return this.stream.getInputBuffer().isRequestBodyFullyRead();
    }

    @Override
    protected final void registerReadInterest() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected final boolean isReadyForWrite() {
        return this.stream.isReadyForWrite();
    }

    @Override
    protected final void executeDispatches() {
        Iterator<DispatchType> dispatches = this.getIteratorAndClearDispatches();
        while (dispatches != null && dispatches.hasNext()) {
            DispatchType dispatchType = dispatches.next();
            this.processSocketEvent(dispatchType.getSocketStatus(), true);
        }
    }

    @Override
    protected final boolean isPushSupported() {
        return this.stream.isPushSupported();
    }

    @Override
    protected final void doPush(Request pushTarget) {
        try {
            this.stream.push(pushTarget);
        }
        catch (IOException ioe) {
            this.setErrorState(ErrorState.CLOSE_CONNECTION_NOW, ioe);
            this.response.setErrorException(ioe);
        }
    }

    @Override
    protected boolean isTrailerFieldsReady() {
        return this.stream.isTrailerFieldsReady();
    }

    @Override
    protected boolean isTrailerFieldsSupported() {
        return this.stream.isTrailerFieldsSupported();
    }

    @Override
    protected Object getConnectionID() {
        return this.stream.getConnectionId();
    }

    @Override
    protected Object getStreamID() {
        return this.stream.getIdAsString().toString();
    }

    @Override
    public final void recycle() {
        RequestGroupInfo global = this.handler.getProtocol().getGlobal();
        if (global != null) {
            global.removeRequestProcessor(this.request.getRequestProcessor());
        }
        this.setSocketWrapper(null);
    }

    @Override
    protected final Log getLog() {
        return log;
    }

    @Override
    public final void pause() {
    }

    @Override
    public final AbstractEndpoint.Handler.SocketState service(SocketWrapperBase<?> socket) throws IOException {
        try {
            this.adapter.service(this.request, this.response);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("streamProcessor.service.error"), (Throwable)e);
            }
            this.response.setStatus(500);
            this.setErrorState(ErrorState.CLOSE_NOW, e);
        }
        if (!this.isAsync()) {
            this.endRequest();
        }
        if (this.sendfileState == SendfileState.PENDING) {
            return AbstractEndpoint.Handler.SocketState.SENDFILE;
        }
        if (this.getErrorState().isError()) {
            this.action(ActionCode.CLOSE, null);
            this.request.updateCounters();
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }
        if (this.isAsync()) {
            return AbstractEndpoint.Handler.SocketState.LONG;
        }
        this.action(ActionCode.CLOSE, null);
        this.request.updateCounters();
        return AbstractEndpoint.Handler.SocketState.CLOSED;
    }

    @Override
    protected final boolean flushBufferedWrite() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("streamProcessor.flushBufferedWrite.entry", this.stream.getConnectionId(), this.stream.getIdAsString()));
        }
        if (this.stream.flush(false)) {
            if (this.stream.isReadyForWrite()) {
                throw new IllegalStateException();
            }
            return true;
        }
        return false;
    }

    @Override
    protected final AbstractEndpoint.Handler.SocketState dispatchEndRequest() throws IOException {
        this.endRequest();
        return AbstractEndpoint.Handler.SocketState.CLOSED;
    }

    private void endRequest() throws IOException {
        if (!this.stream.isInputFinished() && this.getErrorState().isIoAllowed()) {
            if (this.handler.hasAsyncIO() && !this.stream.isContentLengthInconsistent()) {
                return;
            }
            StreamException se = new StreamException(sm.getString("streamProcessor.cancel", this.stream.getConnectionId(), this.stream.getIdAsString()), Http2Error.CANCEL, this.stream.getIdAsInt());
            this.handler.sendStreamReset(se);
        }
    }
}

