/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.connector.http2;

import com.tongweb.commons.logger.logging.Log;
import com.tongweb.commons.logger.logging.LogFactory;
import com.tongweb.connector.http2.AbstractStream;
import com.tongweb.connector.http2.FrameType;
import com.tongweb.connector.http2.Http2Exception;
import com.tongweb.connector.http2.Stream;
import com.tongweb.connector.http2.StreamStateMachine;
import com.tongweb.web.util.res.StringManager;
import java.util.Iterator;

abstract class AbstractNonZeroStream
extends AbstractStream {
    private static final Log log = LogFactory.getLog(AbstractNonZeroStream.class);
    private static final StringManager sm = StringManager.getManager(AbstractNonZeroStream.class);
    protected final StreamStateMachine state;
    private volatile int weight = 16;

    AbstractNonZeroStream(String connectionId, Integer identifier) {
        super(identifier);
        this.state = new StreamStateMachine(connectionId, this.getIdAsString());
    }

    AbstractNonZeroStream(Integer identifier, StreamStateMachine state) {
        super(identifier);
        this.state = state;
    }

    @Override
    final int getWeight() {
        return this.weight;
    }

    final void rePrioritise(AbstractStream parent, boolean exclusive, int weight) {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("stream.reprioritisation.debug", this.getConnectionId(), this.getIdAsString(), Boolean.toString(exclusive), parent.getIdAsString(), Integer.toString(weight)));
        }
        if (this.isDescendant(parent)) {
            parent.detachFromParent();
            this.getParentStream().addChild((Stream)parent);
        }
        if (exclusive) {
            Iterator<AbstractNonZeroStream> parentsChildren = parent.getChildStreams().iterator();
            while (parentsChildren.hasNext()) {
                AbstractNonZeroStream parentsChild = parentsChildren.next();
                parentsChildren.remove();
                this.addChild(parentsChild);
            }
        }
        this.detachFromParent();
        parent.addChild(this);
        this.weight = weight;
    }

    final void rePrioritise(AbstractStream parent, int weight) {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("stream.reprioritisation.debug", this.getConnectionId(), this.getIdAsString(), Boolean.FALSE, parent.getIdAsString(), Integer.toString(weight)));
        }
        parent.addChild(this);
        this.weight = weight;
    }

    void replaceStream(AbstractNonZeroStream replacement) {
        replacement.setParentStream(this.getParentStream());
        this.detachFromParent();
        for (AbstractNonZeroStream child : this.getChildStreams()) {
            replacement.addChild(child);
        }
        this.getChildStreams().clear();
        replacement.weight = this.weight;
    }

    final boolean isClosedFinal() {
        return this.state.isClosedFinal();
    }

    final void checkState(FrameType frameType) throws Http2Exception {
        this.state.checkFrameType(frameType);
    }
}

