/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.http;

import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;
import javax.servlet.http.CookieNameValidator;
import javax.servlet.http.RFC2109Validator;
import javax.servlet.http.RFC6265Validator;

public class Cookie
implements Cloneable,
Serializable {
    private static final CookieNameValidator validation;
    private static final long serialVersionUID = 1L;
    private final String name;
    private String value;
    private int version = 0;
    private String comment;
    private String domain;
    private int maxAge = -1;
    private String path;
    private boolean secure;
    private boolean httpOnly;

    public Cookie(String name, String value) {
        validation.validate(name);
        this.name = name;
        this.value = value;
    }

    public void setComment(String purpose) {
        this.comment = purpose;
    }

    public String getComment() {
        return this.comment;
    }

    public void setDomain(String pattern) {
        this.domain = pattern.toLowerCase(Locale.ENGLISH);
    }

    public String getDomain() {
        return this.domain;
    }

    public void setMaxAge(int expiry) {
        this.maxAge = expiry;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public void setPath(String uri) {
        this.path = uri;
    }

    public String getPath() {
        return this.path;
    }

    public void setSecure(boolean flag) {
        this.secure = flag;
    }

    public boolean getSecure() {
        return this.secure;
    }

    public String getName() {
        return this.name;
    }

    public void setValue(String newValue) {
        this.value = newValue;
    }

    public String getValue() {
        return this.value;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int v) {
        this.version = v;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public void setHttpOnly(boolean httpOnly) {
        this.httpOnly = httpOnly;
    }

    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    static {
        String propFwdSlashIsSeparator;
        String propStrictNaming;
        boolean strictServletCompliance;
        if (System.getSecurityManager() == null) {
            strictServletCompliance = Boolean.getBoolean("com.tongweb.container.STRICT_SERVLET_COMPLIANCE");
            propStrictNaming = System.getProperty("com.tongweb.web.util.http.ServerCookie.STRICT_NAMING");
            propFwdSlashIsSeparator = System.getProperty("com.tongweb.web.util.http.ServerCookie.FWD_SLASH_IS_SEPARATOR");
        } else {
            strictServletCompliance = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return Boolean.valueOf(System.getProperty("com.tongweb.container.STRICT_SERVLET_COMPLIANCE"));
                }
            });
            propStrictNaming = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty("com.tongweb.web.util.http.ServerCookie.STRICT_NAMING");
                }
            });
            propFwdSlashIsSeparator = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty("com.tongweb.web.util.http.ServerCookie.FWD_SLASH_IS_SEPARATOR");
                }
            });
        }
        boolean strictNaming = propStrictNaming == null ? strictServletCompliance : Boolean.parseBoolean(propStrictNaming);
        boolean allowSlash = propFwdSlashIsSeparator == null ? !strictServletCompliance : !Boolean.parseBoolean(propFwdSlashIsSeparator);
        validation = strictNaming ? new RFC2109Validator(allowSlash) : new RFC6265Validator();
    }
}

