/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.web.util.net.openssl;

import com.tongweb.commons.logger.logging.Log;
import com.tongweb.commons.logger.logging.LogFactory;
import com.tongweb.web.jni.SSLConf;
import com.tongweb.web.util.net.openssl.OpenSSLConfCmd;
import com.tongweb.web.util.res.StringManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class OpenSSLConf
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(OpenSSLConf.class);
    private static final StringManager sm = StringManager.getManager(OpenSSLConf.class);
    private final List<OpenSSLConfCmd> commands = new ArrayList<OpenSSLConfCmd>();

    public void addCmd(OpenSSLConfCmd cmd) {
        this.commands.add(cmd);
    }

    public List<OpenSSLConfCmd> getCommands() {
        return this.commands;
    }

    public boolean check(long cctx) throws Exception {
        boolean result = true;
        Iterator<OpenSSLConfCmd> iterator = this.commands.iterator();
        while (iterator.hasNext()) {
            int rc;
            OpenSSLConfCmd command;
            OpenSSLConfCmd cmd = command = iterator.next();
            String name = cmd.getName();
            String value = cmd.getValue();
            if (name == null) {
                log.error((Object)sm.getString("opensslconf.noCommandName", value));
                result = false;
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("opensslconf.checkCommand", name, value));
            }
            try {
                rc = SSLConf.check(cctx, name, value);
            }
            catch (Exception e) {
                log.error((Object)sm.getString("opensslconf.checkFailed"));
                return false;
            }
            if (rc <= 0) {
                log.error((Object)sm.getString("opensslconf.failedCommand", name, value, Integer.toString(rc)));
                result = false;
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)sm.getString("opensslconf.resultCommand", name, value, Integer.toString(rc)));
        }
        if (!result) {
            log.error((Object)sm.getString("opensslconf.checkFailed"));
        }
        return result;
    }

    public boolean apply(long cctx, long ctx) throws Exception {
        int rc;
        boolean result = true;
        SSLConf.assign(cctx, ctx);
        Iterator<OpenSSLConfCmd> iterator = this.commands.iterator();
        while (iterator.hasNext()) {
            OpenSSLConfCmd command;
            OpenSSLConfCmd cmd = command = iterator.next();
            String name = cmd.getName();
            String value = cmd.getValue();
            if (name == null) {
                log.error((Object)sm.getString("opensslconf.noCommandName", value));
                result = false;
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("opensslconf.applyCommand", name, value));
            }
            try {
                rc = SSLConf.apply(cctx, name, value);
            }
            catch (Exception e) {
                log.error((Object)sm.getString("opensslconf.applyFailed"));
                return false;
            }
            if (rc <= 0) {
                log.error((Object)sm.getString("opensslconf.failedCommand", name, value, Integer.toString(rc)));
                result = false;
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)sm.getString("opensslconf.resultCommand", name, value, Integer.toString(rc)));
        }
        rc = SSLConf.finish(cctx);
        if (rc <= 0) {
            log.error((Object)sm.getString("opensslconf.finishFailed", Integer.toString(rc)));
            result = false;
        }
        if (!result) {
            log.error((Object)sm.getString("opensslconf.applyFailed"));
        }
        return result;
    }
}

