/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.web.util.bcel.classfile;

import com.tongweb.web.util.bcel.classfile.Constant;
import com.tongweb.web.util.bcel.classfile.ConstantClass;
import com.tongweb.web.util.bcel.classfile.ConstantPool;
import com.tongweb.web.util.bcel.classfile.ConstantUtf8;
import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;

final class Utility {
    private Utility() {
    }

    static String compactClassName(String str) {
        return str.replace('/', '.');
    }

    static String getClassName(ConstantPool constant_pool, int index) {
        Constant c = constant_pool.getConstant(index, (byte)7);
        int i = ((ConstantClass)c).getNameIndex();
        c = constant_pool.getConstant(i, (byte)1);
        String name = ((ConstantUtf8)c).getBytes();
        return Utility.compactClassName(name);
    }

    static void skipFully(DataInput file, int length) throws IOException {
        int total = file.skipBytes(length);
        if (total != length) {
            throw new EOFException();
        }
    }

    static void swallowFieldOrMethod(DataInput file) throws IOException {
        Utility.skipFully(file, 6);
        int attributes_count = file.readUnsignedShort();
        for (int i = 0; i < attributes_count; ++i) {
            Utility.swallowAttribute(file);
        }
    }

    static void swallowAttribute(DataInput file) throws IOException {
        Utility.skipFully(file, 2);
        int length = file.readInt();
        Utility.skipFully(file, length);
    }
}

