/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.web.buildutil;

import com.tongweb.web.util.buf.StringUtils;
import com.tongweb.web.util.codec.binary.Base64;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SignCode
extends Task {
    private static final URL SIGNING_SERVICE_URL;
    private static final String NS = "cod";
    private static final MessageFactory SOAP_MSG_FACTORY;
    private final List<FileSet> filesets = new ArrayList<FileSet>();
    private String userName;
    private String password;
    private String partnerCode;
    private String keyStore;
    private String keyStorePassword;
    private String applicationName;
    private String applicationVersion;
    private String signingService;
    private boolean debug;

    public void addFileset(FileSet fileset) {
        this.filesets.add(fileset);
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setPartnerCode(String partnerCode) {
        this.partnerCode = partnerCode;
    }

    public void setKeyStore(String keyStore) {
        this.keyStore = keyStore;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public void setApplicationVersion(String applicationVersion) {
        this.applicationVersion = applicationVersion;
    }

    public void setSigningService(String signingService) {
        this.signingService = signingService;
    }

    public void setDebug(String debug) {
        this.debug = Boolean.parseBoolean(debug);
    }

    public void execute() throws BuildException {
        ArrayList<File> filesToSign = new ArrayList<File>();
        for (FileSet fileset : this.filesets) {
            DirectoryScanner ds = fileset.getDirectoryScanner(this.getProject());
            File basedir = ds.getBasedir();
            String[] files = ds.getIncludedFiles();
            if (files.length <= 0) continue;
            for (String s : files) {
                File file = new File(basedir, s);
                filesToSign.add(file);
            }
        }
        System.setProperty("javax.net.ssl.keyStore", this.keyStore);
        System.setProperty("javax.net.ssl.keyStorePassword", this.keyStorePassword);
        try {
            String signingSetID = this.makeSigningRequest(filesToSign);
            this.downloadSignedFiles(filesToSign, signingSetID);
        }
        catch (IOException | SOAPException e) {
            throw new BuildException(e);
        }
    }

    private String makeSigningRequest(List<File> filesToSign) throws SOAPException, IOException {
        this.log("Constructing the code signing request");
        SOAPMessage message = SOAP_MSG_FACTORY.createMessage();
        SOAPBody body = SignCode.populateEnvelope(message, NS);
        SOAPElement requestSigning = body.addChildElement("requestSigning", NS);
        SOAPElement requestSigningRequest = requestSigning.addChildElement("requestSigningRequest", NS);
        SignCode.addCredentials(requestSigningRequest, this.userName, this.password, this.partnerCode);
        SOAPElement applicationName = requestSigningRequest.addChildElement("applicationName", NS);
        applicationName.addTextNode(this.applicationName);
        SOAPElement applicationVersion = requestSigningRequest.addChildElement("applicationVersion", NS);
        applicationVersion.addTextNode(this.applicationVersion);
        SOAPElement signingServiceName = requestSigningRequest.addChildElement("signingServiceName", NS);
        signingServiceName.addTextNode(this.signingService);
        List<String> fileNames = SignCode.getFileNames(filesToSign);
        SOAPElement commaDelimitedFileNames = requestSigningRequest.addChildElement("commaDelimitedFileNames", NS);
        commaDelimitedFileNames.addTextNode(StringUtils.join(fileNames));
        SOAPElement application = requestSigningRequest.addChildElement("application", NS);
        application.addTextNode(SignCode.getApplicationString(fileNames, filesToSign));
        SOAPConnectionFactory soapConnectionFactory = SOAPConnectionFactory.newInstance();
        SOAPConnection connection = soapConnectionFactory.createConnection();
        this.log("Sending signing request to server and waiting for response");
        SOAPMessage response = connection.call(message, (Object)SIGNING_SERVICE_URL);
        if (this.debug) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(2048);
            response.writeTo((OutputStream)baos);
            this.log(baos.toString("UTF-8"));
        }
        this.log("Processing response");
        SOAPBody responseBody = response.getSOAPBody();
        NodeList bodyNodes = responseBody.getChildNodes();
        NodeList requestSigningResponseNodes = bodyNodes.item(0).getChildNodes();
        NodeList returnNodes = requestSigningResponseNodes.item(0).getChildNodes();
        String signingSetID = null;
        String signingSetStatus = null;
        for (int i = 0; i < returnNodes.getLength(); ++i) {
            Node returnNode = returnNodes.item(i);
            if (returnNode.getLocalName().equals("signingSetID")) {
                signingSetID = returnNode.getTextContent();
                continue;
            }
            if (!returnNode.getLocalName().equals("signingSetStatus")) continue;
            signingSetStatus = returnNode.getTextContent();
        }
        if (!this.signingService.contains("TEST") && !"SIGNED".equals(signingSetStatus) || this.signingService.contains("TEST") && !"INITIALIZED".equals(signingSetStatus)) {
            throw new BuildException("Signing failed. Status was: " + signingSetStatus);
        }
        return signingSetID;
    }

    private void downloadSignedFiles(List<File> filesToSign, String id) throws SOAPException, IOException {
        this.log("Downloading signed files. The signing set ID is: " + id);
        SOAPMessage message = SOAP_MSG_FACTORY.createMessage();
        SOAPBody body = SignCode.populateEnvelope(message, NS);
        SOAPElement getSigningSetDetails = body.addChildElement("getSigningSetDetails", NS);
        SOAPElement getSigningSetDetailsRequest = getSigningSetDetails.addChildElement("getSigningSetDetailsRequest", NS);
        SignCode.addCredentials(getSigningSetDetailsRequest, this.userName, this.password, this.partnerCode);
        SOAPElement signingSetID = getSigningSetDetailsRequest.addChildElement("signingSetID", NS);
        signingSetID.addTextNode(id);
        SOAPElement returnApplication = getSigningSetDetailsRequest.addChildElement("returnApplication", NS);
        returnApplication.addTextNode("true");
        SOAPConnectionFactory soapConnectionFactory = SOAPConnectionFactory.newInstance();
        SOAPConnection connection = soapConnectionFactory.createConnection();
        this.log("Requesting signed files from server and waiting for response");
        SOAPMessage response = connection.call(message, (Object)SIGNING_SERVICE_URL);
        this.log("Processing response");
        SOAPBody responseBody = response.getSOAPBody();
        NodeList bodyNodes = responseBody.getChildNodes();
        NodeList getSigningSetDetailsResponseNodes = bodyNodes.item(0).getChildNodes();
        NodeList returnNodes = getSigningSetDetailsResponseNodes.item(0).getChildNodes();
        String result = null;
        String data = null;
        for (int i = 0; i < returnNodes.getLength(); ++i) {
            Node returnNode = returnNodes.item(i);
            if (returnNode.getLocalName().equals("result")) {
                result = returnNode.getChildNodes().item(0).getTextContent();
                continue;
            }
            if (!returnNode.getLocalName().equals("signingSet")) continue;
            data = returnNode.getChildNodes().item(1).getTextContent();
        }
        if (!"0".equals(result)) {
            throw new BuildException("Download failed. Result code was: " + result);
        }
        SignCode.extractFilesFromApplicationString(data, filesToSign);
    }

    private static SOAPBody populateEnvelope(SOAPMessage message, String namespace) throws SOAPException {
        SOAPPart soapPart = message.getSOAPPart();
        SOAPEnvelope envelope = soapPart.getEnvelope();
        envelope.addNamespaceDeclaration("soapenv", "http://schemas.xmlsoap.org/soap/envelope/");
        envelope.addNamespaceDeclaration(namespace, "http://api.ws.symantec.com/webtrust/codesigningservice");
        return envelope.getBody();
    }

    private static void addCredentials(SOAPElement requestSigningRequest, String user, String pwd, String code) throws SOAPException {
        SOAPElement authToken = requestSigningRequest.addChildElement("authToken", NS);
        SOAPElement userName = authToken.addChildElement("userName", NS);
        userName.addTextNode(user);
        SOAPElement password = authToken.addChildElement("password", NS);
        password.addTextNode(pwd);
        SOAPElement partnerCode = authToken.addChildElement("partnerCode", NS);
        partnerCode.addTextNode(code);
    }

    private static List<String> getFileNames(List<File> filesToSign) {
        ArrayList<String> result = new ArrayList<String>(filesToSign.size());
        for (int i = 0; i < filesToSign.size(); ++i) {
            File f = filesToSign.get(i);
            String fileName = f.getName();
            int extIndex = fileName.lastIndexOf(46);
            String newName = extIndex < 0 ? Integer.toString(i) : Integer.toString(i) + fileName.substring(extIndex);
            result.add(newName);
        }
        return result;
    }

    private static String getApplicationString(List<String> fileNames, List<File> files) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(0x1000000);
        try (ZipOutputStream zos = new ZipOutputStream(baos);){
            byte[] buf = new byte[32768];
            for (int i = 0; i < files.size(); ++i) {
                try (FileInputStream fis = new FileInputStream(files.get(i));){
                    int numRead;
                    ZipEntry zipEntry = new ZipEntry(fileNames.get(i));
                    zos.putNextEntry(zipEntry);
                    while ((numRead = fis.read(buf)) >= 0) {
                        zos.write(buf, 0, numRead);
                    }
                    continue;
                }
            }
        }
        return Base64.encodeBase64String(baos.toByteArray());
    }

    private static void extractFilesFromApplicationString(String data, List<File> files) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(Base64.decodeBase64(data));
        try (ZipInputStream zis = new ZipInputStream(bais);){
            byte[] buf = new byte[32768];
            for (File file : files) {
                FileOutputStream fos = new FileOutputStream(file);
                Throwable throwable = null;
                try {
                    int numRead;
                    zis.getNextEntry();
                    while ((numRead = zis.read(buf)) >= 0) {
                        fos.write(buf, 0, numRead);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (fos == null) continue;
                    if (throwable != null) {
                        try {
                            fos.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    fos.close();
                }
            }
        }
    }

    static {
        try {
            SIGNING_SERVICE_URL = new URL("https://api-appsec.pki.digicert.com/webtrust/SigningService");
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
        try {
            SOAP_MSG_FACTORY = MessageFactory.newInstance((String)"SOAP 1.1 Protocol");
        }
        catch (SOAPException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

